/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.imageCanvas;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class ScalingImageCanvas
extends ImageCanvas {
    private double _xScale = 1.0;
    private double _yScale = 1.0;
    private double _xAdjust = 1.0;
    private double _yAdjust = 1.0;
    private Painter _painter = new AlignmentPainter(new Scaler(new ImagePainter(2)));

    public ScalingImageCanvas() {
        this(null);
    }

    public ScalingImageCanvas(Image image) {
        super(image);
    }

    public double getXScalingFactor() {
        return this._xScale;
    }

    public void setXScalingFactor(double d) {
        this._xAdjust *= d / this._xScale;
        this._xScale = d;
        this.invalidateCanvas();
    }

    public double getYScalingFactor() {
        return this._yScale;
    }

    public void setYScalingFactor(double d) {
        this._yAdjust *= d / this._yScale;
        this._yScale = d;
        this.invalidateCanvas();
    }

    public void setCanvasSize(int n, int n2) {
        Point point = this.getCanvasOrigin();
        super.setCanvasSize(n, n2);
        Dimension dimension = this.getInnerSize();
        if (this._xAdjust != 1.0) {
            point.x = Math.max((int)((double)point.x * this._xAdjust), Math.min(0, dimension.width - n));
            this._xAdjust = 1.0;
        }
        if (this._yAdjust != 1.0) {
            point.y = Math.max((int)((double)point.y * this._yAdjust), Math.min(0, dimension.height - n2));
            this._yAdjust = 1.0;
        }
        this.setCanvasOrigin(point.x, point.y);
    }

    protected Dimension layoutCanvas() {
        Image image = this.getImage();
        if (image != null) {
            int n = image.getWidth(this);
            int n2 = image.getHeight(this);
            Dimension dimension = this.getInnerSize();
            dimension.width = Math.max(dimension.width, (int)((double)n * this._xScale));
            dimension.height = Math.max(dimension.height, (int)((double)n2 * this._yScale));
            return dimension;
        }
        return new Dimension(0, 0);
    }

    protected Painter getPainter() {
        return this._painter;
    }

    private class Scaler
    extends AbstractWrappingPainter {
        public Scaler(Painter painter) {
            super(painter);
        }

        public Dimension getSize(PaintContext paintContext, int n, int n2) {
            Dimension dimension = this.getPreferredSize(paintContext);
            dimension.width = (int)((double)dimension.width * ScalingImageCanvas.this.getXScalingFactor());
            dimension.height = (int)((double)dimension.height * ScalingImageCanvas.this.getYScalingFactor());
            return dimension;
        }
    }
}

