/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.header;

import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderSelection;

public class SingleItemSelection
implements HeaderSelection {
    private Header _header;
    private int _item = -1;

    public void setParent(Header header) {
        this._header = header;
        this._item = -1;
    }

    public void itemsAdded(int n, int n2) {
        if (this._item == -1 || this._item < n) {
            return;
        }
        this._item += n2;
    }

    public void itemsRemoved(int n, int n2) {
        if (this._item == -1 || this._item < n) {
            return;
        }
        this._item = this._item < n + n2 ? -1 : (this._item -= n2);
    }

    public void setItemSelected(int n, boolean bl) {
        if (this.isItemSelected(n) == bl) {
            return;
        }
        if (bl) {
            this.deselectAll();
            if (this._header.fireCancelableEvent(2001, n)) {
                return;
            }
            this._item = n;
            this._header.fireEvent(2002, n);
            if (this._header.getDrawSelected()) {
                this._header.paintItem(n);
            }
        } else {
            if (this._header.fireCancelableEvent(2003, n)) {
                return;
            }
            this._item = -1;
            this._header.fireEvent(2004, n);
            if (this._header.getDrawSelected()) {
                this._header.paintItem(n);
            }
        }
    }

    public boolean isItemSelected(int n) {
        return n == this._item;
    }

    public int[] getSelectedItems() {
        if (this._item == -1) {
            return null;
        }
        int[] nArray = new int[]{this._item};
        return nArray;
    }

    public void selectItemRange(int n, int n2) {
        if (this.isItemSelected(n)) {
            return;
        }
        this.deselectAll();
        this.setItemSelected(n, true);
    }

    public void deselectAll() {
        if (this._item != -1) {
            this.setItemSelected(this._item, false);
        }
        this._item = -1;
    }

    public void addItemToSelection(int n) {
        this.setItemSelected(n, true);
    }

    public void removeItemFromSelection(int n) {
        this.setItemSelected(n, false);
    }
}

