/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridKeyAdapter;
import oracle.ewt.iterator.ArrayIterator;
import oracle.ewt.iterator.Iterator;
import oracle.ewt.iterator.NumericIterator;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.spinBox.SpinBox;
import oracle.ewt.spinBox.SpinBoxEvent;
import oracle.ewt.spinBox.SpinBoxListener;
import oracle.ewt.spinBox.SpinBuddy;
import oracle.ewt.util.InputEventUtils;

public class SpinBoxInputHandler
extends CellInputHandler {
    private static final String _ASSERT_STRING = "SpinBoxInputHandler.setIteratorValue() does not recognize the Iterator.  Clients must override this method to initialize their Iterator class.";
    private KeyListener _keyListener;
    private Focus _focusListener;
    private SpinBox _spinBox;
    boolean _dirty;

    public void setIterator(Iterator iterator) {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        spinBox.setIterator(iterator);
    }

    public Iterator getIterator() {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        return spinBox.getIterator();
    }

    public void setSpinBuddy(SpinBuddy spinBuddy) {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        spinBox.setSpinBuddy(spinBuddy);
    }

    public SpinBuddy getSpinBuddy() {
        SpinBox spinBox = this.getSpinBox(null, -1, -1);
        return spinBox.getSpinBuddy();
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        Cell cell = grid.getFocusCell();
        if (cell.column == n && cell.row == n2 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        keyEvent.consume();
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public SpinBox getSpinBox(Grid grid, int n, int n2) {
        return (SpinBox)this.getEditControl(grid, n, n2);
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._spinBox == null) {
            this._spinBox = this.createSpinBox();
            this._spinBox.setBorderPainter(new FixedBorderPainter(0, 2, 0, 0));
            this._spinBox.addSpinBoxListener(new Dirty());
        }
        return this._spinBox;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        SpinBox spinBox = this.getSpinBox(grid, n, n2);
        Iterator iterator = spinBox.getIterator();
        this.setIteratorValue(iterator, object);
        spinBox.setIterator(iterator);
        Component component = (Component)((Object)spinBox.getSpinBuddy());
        this._keyListener = new GridKeyAdapter(grid);
        this._focusListener = new Focus(grid);
        component.addKeyListener(this._focusListener);
        component.addKeyListener(this._keyListener);
        component.addFocusListener(this._focusListener);
        this._dirty = false;
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        SpinBox spinBox = this.getSpinBox(grid, n, n2);
        Component component = (Component)((Object)spinBox.getSpinBuddy());
        component.removeKeyListener(this._focusListener);
        component.removeKeyListener(this._keyListener);
        component.removeFocusListener(this._focusListener);
        return spinBox.getValue();
    }

    public void cancelEdit(Grid grid, int n, int n2) {
        SpinBox spinBox = this.getSpinBox(grid, n, n2);
        Component component = (Component)((Object)spinBox.getSpinBuddy());
        component.removeKeyListener(this._focusListener);
        component.removeKeyListener(this._keyListener);
        component.removeFocusListener(this._focusListener);
    }

    protected SpinBox createSpinBox() {
        return new SpinBox();
    }

    protected void setIteratorValue(Iterator iterator, Object object) {
        if (iterator instanceof ArrayIterator) {
            ArrayIterator arrayIterator = (ArrayIterator)iterator;
            Object[] objectArray = arrayIterator.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (object != objectArray[i]) continue;
                arrayIterator.setIndex(i);
                break;
            }
        } else if (iterator instanceof NumericIterator && object != null && object instanceof Number) {
            int n = ((Number)object).intValue();
            ((NumericIterator)iterator).setValue(n);
        }
    }

    private class Focus
    extends KeyAdapter
    implements FocusListener {
        private Grid _grid;

        public Focus(Grid grid) {
            this._grid = grid;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Grid grid = this._grid;
            if (grid != null) {
                this._grid = null;
                grid.commitCellEdit();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                this._grid = null;
            }
        }
    }

    private class Dirty
    implements SpinBoxListener {
        private Dirty() {
        }

        public void spinBoxValueChanged(SpinBoxEvent spinBoxEvent) {
            SpinBoxInputHandler.this._dirty = true;
        }
    }
}

