/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ImageLoader;
import oracle.ewt.graphics.NullImageFilter;

public class ImageUtils {
    public static final String CHECK_IMAGE = "Grid.checkImage";
    public static final String EXPAND_IMAGE = "Tree.closedImage";
    public static final String COLLAPSE_IMAGE = "Tree.openImage";
    private static final String _NOLOAD_DATA = "GIF89a\u000e\u0000\u0010\u0000\u00b3\u0000\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u00c0\u00c0\u00c0\u0080\u0080\u0080\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0000\u0000\u0000\u0000\u000e\u0000\u0010\u0000\u0000\u0004I\u0010\u00c8I\u00d1\u00bb\u00e0\u00ea\u008d\u00ec\u00cbG(\u0086\u0096\u0005\u0086\u0082 z\u00c8)(\u0002\u0010Rn*\u008b\u00dfyH\u00e3\u0091?\u00bd\u0003c\u0098\u0091\u0000\u0013#\u0086\u0083Q\u00045\u0090\u00a1!\u00a1\tl<g\u0093\u00df\u00c1z\u001dii^c0\u009c\u00d9\u00981\u00b4\u00f4$\u0002\u0000;";
    private static Image _sNotLoadedImage;

    public static Image createFilteredImage(Image image, ImageFilter imageFilter) {
        if (imageFilter != null && imageFilter != NullImageFilter.getImageFilter()) {
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
        return image;
    }

    public static Image createDisabledImage(Image image) {
        ImageFilter imageFilter = UIManager.getImageFilter(LookAndFeel.DISABLING_FILTER);
        if (imageFilter != null) {
            return ImageUtils.createFilteredImage(image, imageFilter);
        }
        return image;
    }

    public static Image getCommonImage(String string) {
        return UIManager.getImage(string);
    }

    public static Image getImageResource(Class clazz, String string) {
        Image image = ImageUtils._getImageResource(clazz, string);
        if (image == null) {
            image = ImageUtils.getNotLoadedImage();
        }
        return image;
    }

    public static Image getNotLoadedImage() {
        if (_sNotLoadedImage == null) {
            _sNotLoadedImage = ImageUtils._createImage(_NOLOAD_DATA);
        }
        return _sNotLoadedImage;
    }

    public static boolean isImageLoaded(Image image) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = toolkit.checkImage(image, -1, -1, null);
        return (n & 0x30) != 0;
    }

    public static boolean loadImage(Image image) {
        if (!ImageUtils.isImageLoaded(image)) {
            ImageLoader imageLoader = new ImageLoader(image);
            imageLoader.start();
            return imageLoader.waitFor();
        }
        return true;
    }

    public static boolean loadImages(Image[] imageArray) {
        int n;
        boolean bl = true;
        ImageLoader[] imageLoaderArray = new ImageLoader[imageArray.length];
        for (n = 0; n < imageArray.length; ++n) {
            ImageLoader imageLoader = new ImageLoader(imageArray[n]);
            imageLoader.start();
            imageLoaderArray[n] = imageLoader;
        }
        for (n = 0; n < imageArray.length; ++n) {
            bl = bl && imageLoaderArray[n].waitFor();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image _getImageResource(Class clazz, String string) {
        Image image = null;
        byte[] byArray = null;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                int n2 = inputStream.available();
                byArray = new byte[n2];
                int n3 = 0;
                do {
                    if ((n = inputStream.read(byArray, n3, n2 - n3)) <= 0) continue;
                    n3 += n;
                } while (n3 < n2 && n > 0);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (byArray != null && !ImageUtils.loadImage(image = Toolkit.getDefaultToolkit().createImage(byArray))) {
            image = null;
        }
        if (image != null) {
            return image;
        }
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            try {
                Object object = uRL.getContent();
                if (object instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)object;
                    image = Toolkit.getDefaultToolkit().createImage(imageProducer);
                } else if (object instanceof Image) {
                    image = (Image)object;
                }
                if (image != null) {
                    if (ImageUtils.loadImage(image)) {
                        return image;
                    }
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private ImageUtils() {
    }

    private static Image _createImage(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }
}

