/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.event.tracking;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.event.tracking.KeyFilterProvider;

public class KeyFilterSupport {
    private Component _comp;
    private KeyListener _keyListener = new KeyLis();
    private ContainerListener _containerListener = new ContLis();
    private KeyListener _keyFilters;
    private boolean _processingFilters;

    public void setComponent(Component component) {
        if (component != this._comp) {
            if (this._comp != null) {
                this._removeListeners(this._comp);
            }
            this._comp = component;
            if (this._comp != null) {
                this._addListeners(this._comp);
            }
        }
    }

    public synchronized void addKeyFilter(KeyListener keyListener) {
        this._keyFilters = AWTEventMulticaster.add(keyListener, this._keyFilters);
    }

    public synchronized void removeKeyFilter(KeyListener keyListener) {
        this._keyFilters = AWTEventMulticaster.remove(this._keyFilters, keyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addListeners(Component component) {
        if (component instanceof KeyFilterProvider && component != this._comp) {
            ((KeyFilterProvider)((Object)component)).addKeyFilter(this._keyListener);
            return;
        }
        component.addKeyListener(this._keyListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = component.getTreeLock();
            synchronized (object) {
                container.addContainerListener(this._containerListener);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this._addListeners(container.getComponent(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _processKeyFilters(KeyEvent keyEvent) {
        if (this._processingFilters) {
            return;
        }
        this._processingFilters = true;
        try {
            KeyListener keyListener = this._keyFilters;
            if (keyListener == null) return;
            switch (keyEvent.getID()) {
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    return;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                    return;
                }
                case 400: {
                    keyListener.keyTyped(keyEvent);
                    return;
                }
            }
            return;
        }
        finally {
            this._processingFilters = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeListeners(Component component) {
        if (component instanceof KeyFilterProvider && this._comp != component) {
            ((KeyFilterProvider)((Object)component)).removeKeyFilter(this._keyListener);
            return;
        }
        component.removeKeyListener(this._keyListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = component.getTreeLock();
            synchronized (object) {
                container.removeContainerListener(this._containerListener);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this._removeListeners(container.getComponent(i));
                }
            }
        }
    }

    private class ContLis
    implements ContainerListener {
        private ContLis() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            KeyFilterSupport.this._addListeners(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            KeyFilterSupport.this._removeListeners(containerEvent.getChild());
        }
    }

    private class KeyLis
    implements KeyListener {
        private KeyLis() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            KeyFilterSupport.this._processKeyFilters(keyEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            KeyFilterSupport.this._processKeyFilters(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            KeyFilterSupport.this._processKeyFilters(keyEvent);
        }
    }
}

