/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.drawer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtComponent;
import oracle.ewt.button.PushButton;
import oracle.ewt.drawer.Drawer;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.plaf.DrawerUI;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarEvent;

class DrawerPopup
extends LWComponent {
    static TaskScheduler _sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    private static final int _SLIDE_OUT_TIME = 200;
    private static final int _STATE_CLOSED = 0;
    private static final int _STATE_OPENING = 1;
    private static final int _STATE_OPEN = 2;
    private transient int _state;
    private transient Slide _slide;
    private transient int _slidingPos;
    private transient int _multiplier;
    private transient boolean _horizontal;
    private transient Image _offscreen;
    private Drawer _parent;
    private PushButton _button;
    private EwtComponent _content;

    public DrawerPopup(Drawer drawer, Component component) {
        this.setLayout(null);
        this._parent = drawer;
        this._content = new EwtComponent();
        this._content.setBackground(component.getBackground());
        this._content.setLayout(new BorderLayout());
        this._content.add(component, "Center");
        if (component instanceof ToolBar) {
            ((ToolBar)component).addToolBarActionListener(new ToolBarActionListener(){

                public void toolBarItemActionPerformed(ToolBarEvent toolBarEvent) {
                    DrawerPopup.this.closeLater();
                }
            });
        }
        if (component instanceof EwtComponent) {
            ((EwtComponent)component).setBorderPainter(null);
        }
        this.add(this._content);
        this._button = new PushButton(){

            public BorderPainter getBorderPainter() {
                return NullPainter.getPainter();
            }
        };
        this._button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawerPopup.this.close();
            }
        });
        this._button.setFocusable(false);
        this._state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this.getTreeLock();
        synchronized (object) {
            DrawerPopup drawerPopup = this;
            synchronized (drawerPopup) {
                if (this._state == 0) {
                    this._setUI();
                    this._fillBuffer();
                    if (this._offscreen == null) {
                        this._state = 2;
                    } else {
                        this._state = 1;
                        Dimension dimension = this._content.getSize();
                        Dimension dimension2 = this._button.getSize();
                        Dimension dimension3 = this.getSize();
                        int n = this._parent.getOrientation();
                        switch (n) {
                            case 1: {
                                this._horizontal = false;
                                this._slidingPos = dimension3.height;
                                break;
                            }
                            case 2: {
                                this._horizontal = false;
                                this._slidingPos = dimension2.height - dimension.height;
                                break;
                            }
                            default: {
                                this._horizontal = true;
                                this._slidingPos = dimension2.width - dimension.width;
                                break;
                            }
                            case 3: {
                                this._horizontal = true;
                                this._slidingPos = dimension3.width;
                            }
                        }
                        this._multiplier = n == 3 || n == 1 ? -1 : 1;
                        if (this._slide == null) {
                            this._slide = new Slide();
                        }
                        this._slide.start();
                    }
                }
            }
        }
        if (this._state == 2) {
            this.synchronizedValidateTree();
        }
    }

    public void closeLater() {
        _sTaskScheduler.schedule(new Task(){

            public void runTask(TaskEvent taskEvent) {
                DrawerPopup.this.close();
            }
        }, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.getTreeLock();
        synchronized (object) {
            DrawerPopup drawerPopup = this;
            synchronized (drawerPopup) {
                if (this._state != 0) {
                    if (this._state == 1) {
                        this._slide.cancel();
                    }
                    this._state = 0;
                    this._parent.popupClosed();
                    if (this._offscreen != null) {
                        this._offscreen.flush();
                        this._offscreen = null;
                    }
                }
            }
            this.doLayout();
        }
        this.repaint();
    }

    public void paintInterior(Graphics graphics) {
        Image image;
        if (this._state == 1 && (image = this._offscreen) != null) {
            if (this._horizontal) {
                graphics.drawImage(image, this._slidingPos, 0, this);
            } else {
                graphics.drawImage(image, 0, this._slidingPos, this);
            }
        }
    }

    public void doLayout() {
        int n = this._state;
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n2 = this._parent.getOrientation();
        int n3 = dimension.width;
        int n4 = dimension.height;
        switch (this._parent.getOrientation()) {
            default: {
                n4 = Math.max(dimension.height, dimension2.height);
                break;
            }
            case 0: 
            case 3: {
                n3 = Math.max(dimension.width, dimension2.width);
            }
        }
        if (n == 2) {
            int n5 = 0;
            int n6 = 0;
            switch (n2) {
                default: {
                    break;
                }
                case 2: {
                    n6 = dimension.height - n4;
                    break;
                }
                case 0: {
                    n5 = dimension.width - n3;
                }
            }
            this._content.setBounds(n5, n6, n3, n4);
        } else {
            this._content.setBounds(-n3, 0, n3, n4);
        }
    }

    public Dimension getMinimumSize() {
        this._setUI();
        return this._content.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        this._setUI();
        return this._content.getPreferredSize();
    }

    public boolean isPaintPropagationRequired(int n, int n2, int n3, int n4) {
        if (this._state == 1) {
            return false;
        }
        return super.isPaintPropagationRequired(n, n2, n3, n4);
    }

    boolean slideOnceMore(int n) {
        int n2;
        int n3;
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this.getSize();
        if (this._horizontal) {
            n3 = dimension2.width - dimension.width;
            n2 = (dimension2.width - n3) * n / 200;
        } else {
            n3 = dimension2.height - dimension.height;
            n2 = (dimension2.height - n3) * n / 200;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this._slidingPos += this._multiplier * n2;
        if (this._multiplier < 0) {
            n3 = 0;
        }
        if (this._slidingPos * this._multiplier < n3) {
            if (this._horizontal) {
                this.paintImmediate(this._slidingPos, 0, dimension.width, dimension.height);
            } else {
                this.paintImmediate(0, this._slidingPos, dimension.width, dimension.height);
            }
            return true;
        }
        this._state = 2;
        this.synchronizedValidateTree();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedValidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    private void _setUI() {
        String string;
        DrawerUI drawerUI = this._parent.getDrawerUI();
        int n = this._parent.getOrientation();
        switch (n) {
            case 1: {
                string = "North";
                break;
            }
            case 2: {
                string = "South";
                break;
            }
            case 3: {
                string = "West";
                break;
            }
            default: {
                string = "East";
            }
        }
        this._content.add((Component)this._button, string);
        this._button.setPainter(drawerUI.getPopUpArrowPainter(this._parent));
        this._content.setBorderPainter(drawerUI.getDrawerBorderPainter(this._parent));
    }

    private void _fillBuffer() {
        EwtComponent ewtComponent = this._content;
        Dimension dimension = ewtComponent.getSize();
        this._offscreen = ewtComponent.createImage(dimension.width, dimension.height);
        if (this._offscreen != null) {
            Graphics graphics = this._offscreen.getGraphics();
            graphics.setColor(ewtComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setColor(ewtComponent.getForeground());
            graphics.setFont(ewtComponent.getFont());
            ((LWComponent)ewtComponent).paint(graphics);
        }
    }

    private class Slide
    implements Task {
        private int _count;

        private Slide() {
        }

        public void runTask(TaskEvent taskEvent) {
            if (DrawerPopup.this.slideOnceMore(this._count)) {
                this._count = 1 + (int)taskEvent.getTimeDelta();
                _sTaskScheduler.schedule(this, 1);
            }
        }

        public void start() {
            this._count = 1;
            _sTaskScheduler.schedule(this, 1);
        }

        public void cancel() {
            _sTaskScheduler.cancel(this);
        }
    }
}

