/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.util.TooManyListenersException;
import oracle.ewt.dnd.DragGestureEvent;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.DragSourceDragEvent;
import oracle.ewt.dnd.DragSourceDropEvent;
import oracle.ewt.dnd.DragSourceEvent;
import oracle.ewt.dnd.DragSourceListener;
import oracle.ewt.dnd.DragTracker;
import oracle.ewt.dnd.InvalidDnDOperationException;

public class DragSourceContext
implements DragSourceListener {
    private static final int _DEFAULT = 0;
    private static final int _ENTER = 1;
    private static final int _OVER = 2;
    private static final int _CHANGED = 3;
    private DragSource _dragSource;
    private Cursor _cursor;
    private DragGestureEvent _trigger;
    private Component _component;
    private int _actions;
    private Transferable _transferable;
    private DragSourceListener _listener;
    private boolean _cursorDirty;
    private int _currentDropAction;
    private DragTracker _tracker;
    private boolean _dragSucceeded;
    private int _dragOperation;
    private Cursor _savedCursor;
    private Component _savedParent;
    private Cursor _savedParentCursor;

    DragSourceContext(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        if (dragGestureEvent == null) {
            throw new NullPointerException("Trigger");
        }
        this._dragSource = dragGestureEvent.getDragSource();
        if (this._dragSource == null) {
            throw new NullPointerException("DragSource");
        }
        this._component = dragGestureEvent.getComponent();
        if (this._component == null) {
            throw new NullPointerException("Component");
        }
        this._actions = dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions();
        if (this._actions == 0) {
            throw new IllegalArgumentException("source actions");
        }
        this._currentDropAction = dragGestureEvent.getDragAction();
        if (this._currentDropAction == 0) {
            throw new IllegalArgumentException("no drag action");
        }
        if (transferable == null) {
            throw new NullPointerException("Transferable");
        }
        this._transferable = transferable;
        this._listener = dragSourceListener;
        this._trigger = dragGestureEvent;
        this._cursor = cursor;
        this._cursorDirty = true;
        this._savedCursor = this._component.getCursor();
        if (this._savedCursor == null) {
            this._savedCursor = Cursor.getDefaultCursor();
        }
        for (Container container = this._component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            this._savedParent = container;
            this._savedParentCursor = container.getCursor();
            if (this._savedParentCursor != null) break;
            this._savedParentCursor = Cursor.getDefaultCursor();
            break;
        }
        this._updateCurrentCursor(0);
        this._forceCursorUpdate();
        DragSource.setCurrentDragSourceContext(this);
        this._tracker = new DragTracker(this, dragGestureEvent.getTriggerEvent(), image, point);
    }

    public DragSource getDragSource() {
        return this._dragSource;
    }

    public Component getComponent() {
        return this._component;
    }

    public DragGestureEvent getTrigger() {
        return this._trigger;
    }

    public int getSourceActions() {
        return this._actions;
    }

    public void setCursor(Cursor cursor) {
        if (this._cursor == null || !this._cursor.equals(cursor)) {
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            this._cursorDirty = true;
            this._cursor = cursor;
            this._forceCursorUpdate();
        }
    }

    public Cursor getCursor() {
        return this._cursor;
    }

    public synchronized void addDragSourceListener(DragSourceListener dragSourceListener) throws TooManyListenersException {
        if (dragSourceListener == null) {
            return;
        }
        if (this.equals(dragSourceListener)) {
            throw new IllegalArgumentException("DragSourceContext may not be its own listener");
        }
        if (this._listener != null) {
            throw new TooManyListenersException();
        }
        this._listener = dragSourceListener;
    }

    public synchronized void removeDragSourceListener(DragSourceListener dragSourceListener) {
        if (this._listener == null || this._listener != dragSourceListener) {
            throw new IllegalArgumentException();
        }
        this._listener = null;
    }

    void transferablesFlavorsChanged() {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this._listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragEnter(dragSourceDragEvent);
        }
        this._updateCurrentCursor(dragSourceDragEvent.getDropAction() & dragSourceDragEvent.getTargetActions());
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this._listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragOver(dragSourceDragEvent);
        }
        this._updateCurrentCursor(dragSourceDragEvent.getDropAction() & dragSourceDragEvent.getTargetActions());
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        DragSourceListener dragSourceListener = this._listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragExit(dragSourceEvent);
        }
        this._updateCurrentCursor(0);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this._listener;
        if (dragSourceListener != null) {
            dragSourceListener.dropActionChanged(dragSourceDragEvent);
        }
        this._currentDropAction = dragSourceDragEvent.getDropAction();
        this._updateCurrentCursor(dragSourceDragEvent.getDropAction() & dragSourceDragEvent.getTargetActions());
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        DragSourceListener dragSourceListener = this._listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragDropEnd(dragSourceDropEvent);
        }
        this._component.setCursor(this._savedCursor);
        this._savedParent.setCursor(this._savedParentCursor);
    }

    public Transferable getTransferable() {
        return this._transferable;
    }

    private void _updateCurrentCursor(int n) {
        int n2;
        if (this._cursorDirty && this._cursor != null) {
            this._cursorDirty = false;
            return;
        }
        Cursor cursor = null;
        cursor = n == 0 ? (((n2 = this.getSourceActions()) & 0x40000000) != 0 ? DragSource.DefaultLinkNoDrop : ((n2 & 2) != 0 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultCopyNoDrop)) : ((n & 0x40000000) != 0 ? DragSource.DefaultLinkDrop : ((n & 2) != 0 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop));
        this.setCursor(cursor);
        this._cursorDirty = false;
    }

    void startDrag() {
        this._component.addMouseListener(this._tracker);
        this._component.addMouseMotionListener(this._tracker);
        this._forceCursorUpdate();
    }

    boolean getDragSucceded() {
        return this._dragSucceeded;
    }

    void setDragOperation(int n) {
        this._dragOperation = n;
    }

    void setDragSuccess(boolean bl) {
        this._dragSucceeded = bl;
    }

    int getDragOperation() {
        return this._dragOperation;
    }

    void cancelDrag() throws InvalidDnDOperationException {
        this._dragSucceeded = false;
        this._tracker.terminateDrag(true);
    }

    private void _forceCursorUpdate() {
        Cursor cursor = this.getCursor();
        this._component.setCursor(cursor);
        this._savedParent.setCursor(cursor);
    }
}

