/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.UIManager;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

class OLAFDialog
extends BufferedDialog {
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final int _BORDER_INSET = 6;
    private static final BorderPainter _sBorder = new FixedBorderPainter(6, 6, 6, 6);
    private static final String _RESOURCE = "oracle.ewt.color.resource.ColorBundle";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_HELP = "HELP";
    private LWContainer _contentContainer;
    private boolean _cancelled;
    private ActionListener _listener;
    private Component _centerOver;

    public OLAFDialog() {
        super((Frame)null);
        this._dialogInit();
    }

    public OLAFDialog(Frame frame) {
        super(frame);
        this._dialogInit();
    }

    public OLAFDialog(Frame frame, String string) {
        super(frame, string);
        this._dialogInit();
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public boolean runDialog() {
        this.pack();
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this._cancelled = false;
        this.setVisible(true);
        return !this._cancelled;
    }

    public Component getContent() {
        return this._contentContainer.getComponentCount() == 0 ? null : this._contentContainer.getComponent(0);
    }

    public void setContent(Component component) {
        this._contentContainer.removeAll();
        if (component != null) {
            this._contentContainer.add("Center", component);
        }
    }

    private void _dialogInit() {
        this.setResizable(false);
        this.setModal(true);
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
        this._listener = new UIListener();
        this._contentContainer = new LWContainer(new BorderLayout());
        this._contentContainer.setBorderPainter(_sBorder);
        LWContainer lWContainer = new LWContainer(new BorderLayout());
        lWContainer.add("Center", this._contentContainer);
        String string = resourceBundle.getString(_KEY_OK);
        LWButton lWButton = new LWButton(StringUtils.stripMnemonic(string));
        lWButton.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        lWButton.setActionCommand(_KEY_OK);
        lWButton.addActionListener(this._listener);
        lWButton.setDefault(true);
        string = resourceBundle.getString(_KEY_CANCEL);
        LWButton lWButton2 = new LWButton(StringUtils.stripMnemonic(string));
        lWButton2.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        lWButton2.setActionCommand(_KEY_CANCEL);
        lWButton2.addActionListener(this._listener);
        string = resourceBundle.getString(_KEY_HELP);
        LWButton lWButton3 = new LWButton(StringUtils.stripMnemonic(string));
        lWButton3.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        lWButton3.setActionCommand(_KEY_HELP);
        lWButton3.addActionListener(this._listener);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add(lWButton);
        buttonBar.add(lWButton2);
        buttonBar.add(lWButton3);
        LWContainer lWContainer2 = new LWContainer(new BorderLayout(0, 6));
        lWContainer2.setBorderPainter(_sBorder);
        lWContainer2.add("Center", lWContainer);
        lWContainer2.add("South", buttonBar);
        this.setLayout(new BorderLayout());
        this.add("Center", lWContainer2);
        Color color = UIManager.getColor("EWTDialog.background");
        if (color != null) {
            this.setBackground(color);
        }
        this.enableEvents(64L);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dismissDialog(true);
        }
    }

    public void postProcessKey(KeyEvent keyEvent) {
        super.postProcessKey(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || keyEvent.getID() != 401) {
            return;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 27: {
                this.dismissDialog(true);
                keyEvent.consume();
                break;
            }
            case 112: 
            case 156: {
                this.fireHelpEvent();
                keyEvent.consume();
            }
        }
    }

    void dismissDialog(boolean bl) {
        this._cancelled = bl;
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    void fireHelpEvent() {
        this.showHelp();
    }

    private class UIListener
    implements ActionListener {
        private UIListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (OLAFDialog._KEY_OK.equals(string)) {
                OLAFDialog.this.dismissDialog(false);
            } else if (OLAFDialog._KEY_CANCEL.equals(string)) {
                OLAFDialog.this.dismissDialog(true);
            } else if (OLAFDialog._KEY_HELP.equals(string)) {
                OLAFDialog.this.fireHelpEvent();
            }
        }
    }
}

