/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.lwText.LWTextField;

class HexEditor
extends LWTextField {
    public static final String PROPERTY_COLOR = "color";
    private PropertyChangeSupport _propertyChangeSupport;
    private static final char _HASH = '#';

    public HexEditor() {
        this.setColumns(7);
        this.enableEvents(4L);
    }

    public boolean isOKToPaste(Transferable transferable) {
        if (!super.isOKToPaste(transferable)) {
            return false;
        }
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        if (string == null) {
            return false;
        }
        int n = this.getSelectionStart();
        return this._validateString(string, n);
    }

    public Color getColor() {
        String string = this.getText();
        if (string == null) {
            return null;
        }
        return ColorUtils.htmlToColor(string);
    }

    public void setColor(Color color) {
        this.setText(ColorUtils.colorToHTML(color));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            int n;
            String string = this.getText();
            int n2 = n = string == null ? 0 : string.length();
            if (n != 7) {
                this.setColor(this.getColor());
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 400) {
            super.processKeyEvent(keyEvent);
            return;
        }
        boolean bl = true;
        int n = this.getSelectionStart();
        char c = keyEvent.getKeyChar();
        if (this._validateString(String.valueOf(c), n)) {
            bl = false;
        }
        if (bl) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processTextEvent(TextEvent textEvent) {
        super.processTextEvent(textEvent);
        this.firePropertyChange(PROPERTY_COLOR, null, this.getColor());
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    private static int _convertHexToInt(String string) {
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        return HexEditor._getIntDigit(string2) * 16 + HexEditor._getIntDigit(string3);
    }

    private static String _convertIntToHex(int n) {
        return HexEditor._getHexDigit((n %= 256) / 16) + HexEditor._getHexDigit(n % 16);
    }

    private static String _getHexDigit(int n) {
        switch (n) {
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return IntegerUtils.getString((int)n);
    }

    private static int _getIntDigit(String string) {
        if ("A".equals(string) || "a".equals(string)) {
            return 10;
        }
        if ("B".equals(string) || "b".equals(string)) {
            return 11;
        }
        if ("C".equals(string) || "c".equals(string)) {
            return 12;
        }
        if ("D".equals(string) || "d".equals(string)) {
            return 13;
        }
        if ("E".equals(string) || "e".equals(string)) {
            return 14;
        }
        if ("F".equals(string) || "f".equals(string)) {
            return 15;
        }
        try {
            Integer n = Integer.valueOf(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private boolean _validateString(String string, int n) {
        String string2 = this.getText();
        int n2 = string2.length();
        int n3 = string2.indexOf(35);
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n4 = n + i;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                if (n4 != 0 || n3 < 0) continue;
                return false;
            }
            if (c == '#') {
                if (n4 == 0) continue;
                return false;
            }
            if (c >= 'a' && c <= 'f') {
                if (n4 != 0 || n3 < 0) continue;
                return false;
            }
            if (c >= 'A' && c <= 'F') {
                if (n4 != 0 || n3 < 0) continue;
                return false;
            }
            return false;
        }
        String string3 = null;
        string3 = n == 0 ? string + string2 : (n >= n2 ? string2 + string : string2.substring(0, n) + string + string2.substring(n, n2));
        int n5 = string3.length();
        if (n5 > 7) {
            return false;
        }
        return n5 != 7 || string3.indexOf(35) != -1;
    }
}

