/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.HelpListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.util.WindowUtils;

public class AlertBean
implements Serializable {
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 1;
    public static final int TYPE_NOTE = 2;
    public static final int TYPE_MISC = 3;
    public static final int BUTTON_YES = 1;
    public static final int BUTTON_NO = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_HELP = 8;
    private static final long serialVersionUID = 3642721842211265592L;
    private String _message = "";
    private String _title = "";
    private int _type = 0;
    private int _buttons = 1;
    private Locale _locale;
    private transient Image _icon;
    private transient Alert _alert;
    private ListenerManager _helpListeners;

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        if (this._type != n) {
            if (n < 0 || n > 3) {
                throw new IllegalArgumentException();
            }
            if (this._alert != null) {
                this._alert = null;
            }
            this._type = n;
        }
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String string) {
        this._message = string;
        if (this._alert != null) {
            this._alert.setMessage(string);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
        if (this._alert != null) {
            this._alert.setTitle(string);
        }
    }

    public Image getIcon() {
        return this._icon;
    }

    public void setIcon(Image image) {
        this._icon = image;
        if (this._alert != null) {
            this._alert.setIcon(image);
        }
    }

    public int getButtons() {
        return this._buttons;
    }

    public void setButtons(int n) {
        this._buttons = n;
        if (this._alert != null) {
            this._alert = null;
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        if (this._alert != null) {
            this._alert.setLocale(locale);
        }
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        if (this._helpListeners == null) {
            this._helpListeners = new ListenerManager();
        }
        this._helpListeners.addListener(helpListener);
        if (this._alert != null) {
            this._alert.addHelpListener(helpListener);
        }
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this._helpListeners.removeListener(helpListener);
        if (this._alert != null) {
            this._alert.removeHelpListener(helpListener);
        }
    }

    public int runAlert(Component component) {
        Frame frame = WindowUtils.parentFrame(component);
        if (this._alert == null || this._alert.getParent() != frame) {
            this._alert = this._createAlert(frame);
        }
        this._alert.setCenterOver(component);
        return this._alert.runAlert();
    }

    private Alert _createAlert(Frame frame) {
        ListenerManager listenerManager;
        Enumeration enumeration;
        Alert alert = new Alert(frame, this._message, this._type, this._buttons);
        if (this._title != null) {
            alert.setTitle(this._title);
        }
        if (this._icon != null) {
            alert.setIcon(this._icon);
        }
        if (this._locale != null) {
            alert.setLocale(this._locale);
        }
        if (this._helpListeners != null && (enumeration = (listenerManager = this._helpListeners).getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                alert.addHelpListener((HelpListener)enumeration.nextElement());
            }
        }
        return alert;
    }
}

