/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureElementVisitor;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.util.Assert;
import oracle.ideimpl.palette2.DeclaredPage;
import oracle.ideimpl.palette2.DeclaredPageModel;
import oracle.javatools.data.HashStructure;

public final class PaletteHook
extends HashStructureHook {
    private volatile List<String> m_palette1PageExclusions = new ArrayList<String>();
    private volatile List<DeclaredPage> m_pages = new ArrayList<DeclaredPage>();
    private Map<String, HashStructureElementVisitor> m_extensions2HashVisitor = Collections.synchronizedMap(new HashMap());
    private volatile List<Class> m_providerClasses = new ArrayList<Class>();
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "palette-hook");
    public static final ElementName PAGE_PROVIDER_NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "pageProvider");
    public static final ElementName PROVIDER_CLASS_NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "providerClassName");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processData(HashStructure hashStructure) {
        PaletteHook paletteHook = this;
        synchronized (paletteHook) {
            List<String> exclusionsResult;
            List<Class> providerClassesResult;
            DeclaredPageModel hookModel = DeclaredPageModel.newInstance(hashStructure);
            List<DeclaredPage> pagesResult = hookModel.getPages();
            if (pagesResult != null && pagesResult.size() > 0) {
                this.m_pages.addAll(pagesResult);
            }
            if ((providerClassesResult = this.loadAndGetProviderClasses()) != null && providerClassesResult.size() > 0) {
                this.m_providerClasses.addAll(providerClassesResult);
            }
            if ((exclusionsResult = hookModel.getPalette1PageExclusions()) != null && exclusionsResult.size() > 0) {
                this.m_palette1PageExclusions.addAll(exclusionsResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DeclaredPage> getPages() {
        PaletteHook paletteHook = this;
        synchronized (paletteHook) {
            ArrayList<DeclaredPage> returnList = new ArrayList<DeclaredPage>(this.m_pages);
            return returnList;
        }
    }

    private List<Class> loadAndGetProviderClasses() {
        ArrayList<Class> providerClasses = new ArrayList<Class>();
        for (String extensionId : this.m_extensions2HashVisitor.keySet()) {
            List providers = this.m_extensions2HashVisitor.get(extensionId).getHashStructure().getAsList("providerClassName");
            if (providers == null) continue;
            ClassLoader cLoader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
            if (cLoader == null) {
                cLoader = Thread.currentThread().getContextClassLoader();
            }
            for (HashStructure className : providers) {
                String clazz = className.getString("#text");
                try {
                    Class<?> cl = Class.forName(clazz, true, cLoader);
                    providerClasses.add(cl);
                }
                catch (ClassNotFoundException e) {
                    Assert.println((String)("Failed to classload " + clazz + " using " + cLoader.toString()));
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }
        return providerClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Class> getProviderClasses() {
        PaletteHook paletteHook = this;
        synchronized (paletteHook) {
            ArrayList<Class> providerClassesResult = new ArrayList<Class>(this.m_providerClasses);
            this.m_providerClasses.clear();
            return providerClassesResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPalette1PageExclusions() {
        PaletteHook paletteHook = this;
        synchronized (paletteHook) {
            ArrayList<String> exclusionsResult = new ArrayList<String>(this.m_palette1PageExclusions);
            this.m_palette1PageExclusions.clear();
            return exclusionsResult;
        }
    }

    public void start(ElementStartContext context) {
        HashStructureElementVisitor hashStructureElementVisitor;
        super.start(context);
        if (!this.m_extensions2HashVisitor.containsKey(context.getExtension().getID())) {
            hashStructureElementVisitor = new HashStructureElementVisitor();
            this.m_extensions2HashVisitor.put(context.getExtension().getID(), hashStructureElementVisitor);
        } else {
            hashStructureElementVisitor = this.m_extensions2HashVisitor.get(context.getExtension().getID());
        }
        context.registerChildVisitor(PAGE_PROVIDER_NAME, (ElementVisitor)hashStructureElementVisitor);
    }
}

