/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetDialog;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsGroup;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.MyComponentsSectionUI;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.javatools.util.Pair;

public class MyComponentsGroupUI
extends PaletteGroupUI
implements DropTargetListener {
    private static final String FAVORITES = PaletteArb.getString(7);
    private static final String CODE_SNIPPETS = PaletteArb.getString(11);
    private static final String RECENTLY_USED = PaletteArb.getString(9);
    private static Map<String, Behavior> BEHAVIORS = new HashMap<String, Behavior>();
    private DropTarget dropTarget = null;

    public MyComponentsGroupUI(String vwState) {
        super(vwState);
    }

    @Override
    protected PaletteSectionUI newSectionUi(PaletteSection section, PaletteGroupUI.CenterPanel panel, String showState) {
        return new MyComponentsSectionUI(panel, showState, section, this);
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
        if (this.dropTarget == null && this.isDropTarget(paletteGroup)) {
            this.dropTarget = new DropTarget(this, 1, this);
        }
        super.setData(paletteGroup);
    }

    private boolean isDropTarget(PaletteGroup paletteGroup) {
        if (null == paletteGroup) {
            return false;
        }
        Behavior behavior = BEHAVIORS.get(paletteGroup.getName());
        return null != behavior ? behavior.isDropTarget() : false;
    }

    @Override
    protected String getMessageText(PaletteGroup paletteGroup) {
        if (null == paletteGroup) {
            return null;
        }
        String groupName = paletteGroup.getName();
        Behavior behavior = BEHAVIORS.get(groupName);
        return null != behavior ? behavior.getMessageText() : null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.acceptOrReject(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.acceptOrReject(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.acceptOrReject(dtde);
    }

    private void acceptOrReject(DropTargetDragEvent dtde) {
        boolean accept;
        PaletteGroup group = this.getPaletteGroup();
        if (null == group) {
            dtde.rejectDrag();
            return;
        }
        Behavior behavior = BEHAVIORS.get(group.getName());
        boolean bl = accept = null != behavior ? behavior.willAccept(dtde) : false;
        if (accept) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean accept;
        PaletteGroup group = this.getPaletteGroup();
        if (null == group) {
            dtde.rejectDrop();
            return;
        }
        Behavior behavior = BEHAVIORS.get(group.getName());
        boolean bl = accept = null != behavior ? behavior.didAccept(dtde, this) : false;
        if (accept) {
            dtde.acceptDrop(1);
            dtde.dropComplete(true);
        } else {
            dtde.rejectDrop();
        }
    }

    protected boolean showCodeSnippetDialog(String snippet) {
        PaletteGroup group = this.getPaletteGroup();
        if (!(group instanceof MyComponentsGroup)) {
            return false;
        }
        MyComponentsCodeSnippetDialog dlg = new MyComponentsCodeSnippetDialog();
        String sectionName = PaletteControllerUI.getInstance().getCurrentSectionName();
        return dlg.invoke((MyComponentsGroup)group, sectionName, null, snippet);
    }

    private Pair<String, String> determineInsertLocation(Point dropPoint) {
        String section = "";
        String item = "";
        PaletteGroupUI.CenterPanel contentPanel = this.getContentPanel();
        Component comp = contentPanel.getComponentAt(dropPoint);
        if (comp != null) {
            String name = comp.getClass().getName();
            if (name.equals(PaletteItemUI.class.getName())) {
                PaletteItemUI pItem = (PaletteItemUI)comp;
                if (pItem != null) {
                    item = pItem.getPaletteItem().getItemId();
                    section = pItem.getPaletteSectionUI().getPaletteSection().getName();
                }
            } else if (name.startsWith(PaletteSectionUI.class.getName())) {
                JLabel pLabel = (JLabel)comp;
                if (pLabel != null) {
                    section = pLabel.getText();
                }
                String prevSectionName = null;
                Component[] components = contentPanel.getComponents();
                for (int i = 0; i < contentPanel.getComponentCount(); ++i) {
                    String cName = components[i].getClass().getName();
                    if (cName.equals(PaletteItemUI.class.getName())) continue;
                    JLabel cLabel = (JLabel)components[i];
                    String cSection = cLabel.getText();
                    if (cSection.equals(section)) break;
                    prevSectionName = cSection;
                }
                section = prevSectionName;
            } else if (name.startsWith(PaletteGroupUI.class.getName())) {
                String lastSectionName = null;
                Component[] components = contentPanel.getComponents();
                for (int i = 0; i < contentPanel.getComponentCount(); ++i) {
                    String cName = components[i].getClass().getName();
                    if (cName.equals(PaletteItemUI.class.getName())) continue;
                    JLabel cLabel = (JLabel)components[i];
                    lastSectionName = cLabel.getText();
                }
                section = lastSectionName;
            }
        }
        return new Pair((Object)section, (Object)item);
    }

    private Pair<String, String> getAugmentedText(PaletteItem item) {
        String pageName = "";
        String groupName = "";
        PaletteGroupUI.CenterPanel contentPanel = this.getContentPanel();
        Component[] components = contentPanel.getComponents();
        for (int i = 0; i < contentPanel.getComponentCount(); ++i) {
            PaletteItemUI itemUI;
            PaletteItem pItem;
            String cName = components[i].getClass().getName();
            if (!cName.equals(PaletteItemUI.class.getName()) || !(pItem = (itemUI = (PaletteItemUI)contentPanel.getComponent(i)).getPaletteItem()).getItemId().equals(item.getItemId())) continue;
            pageName = itemUI.getPageName();
            groupName = itemUI.getGroupName();
            break;
        }
        return new Pair((Object)pageName, (Object)groupName);
    }

    static {
        BEHAVIORS.put(FAVORITES, new FavoritesBehavior());
        BEHAVIORS.put(CODE_SNIPPETS, new SnippetsBehavior());
        BEHAVIORS.put(RECENTLY_USED, new RecentlyUsedBehavior());
    }

    private static class RecentlyUsedBehavior
    extends Behavior {
        private RecentlyUsedBehavior() {
        }

        @Override
        public boolean isDropTarget() {
            return false;
        }

        @Override
        public String getMessageText() {
            return PaletteArb.getString(14);
        }

        @Override
        public boolean willAccept(DropTargetDragEvent dtde) {
            return false;
        }

        @Override
        public boolean didAccept(DropTargetDropEvent dtde, MyComponentsGroupUI ui) {
            return false;
        }
    }

    private static class SnippetsBehavior
    extends Behavior {
        private SnippetsBehavior() {
        }

        @Override
        public boolean isDropTarget() {
            return true;
        }

        @Override
        public String getMessageText() {
            return String.format("%s %s %s %s", PaletteArb.getString(15), PaletteArb.getString(16), PaletteArb.getString(17), PaletteArb.getString(18));
        }

        @Override
        public boolean willAccept(DropTargetDragEvent dtde) {
            if ((dtde.getDropAction() & 3) > 0) {
                if (dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                    try {
                        MyComponentsCodeSnippetItem pI;
                        Object codeData;
                        Object data = dtde.getTransferable().getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                        if (data instanceof MyComponentsCodeSnippetItem && null != (codeData = (pI = (MyComponentsCodeSnippetItem)data).getData("codeSnippet"))) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
                    }
                    return false;
                }
                if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String snippet = String.valueOf(dtde.getTransferable().getTransferData(DataFlavor.stringFlavor));
                        if (snippet != null && snippet.length() > 0) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean didAccept(DropTargetDropEvent dtde, MyComponentsGroupUI ui) {
            if ((dtde.getDropAction() & 3) > 0) {
                if (dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                    try {
                        MyComponentsCodeSnippetItem pI;
                        Object codeData;
                        Object data = dtde.getTransferable().getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                        if (data instanceof MyComponentsCodeSnippetItem && null != (codeData = (pI = (MyComponentsCodeSnippetItem)data).getData("codeSnippet"))) {
                            Pair locs = ui.determineInsertLocation(dtde.getLocation());
                            MyComponentsCodeSnippetItem item = new MyComponentsCodeSnippetItem(pI.getName(), pI.getIconURL(), String.valueOf(codeData));
                            MyComponentsPages pages = ((MyComponentsGroup)ui.getPaletteGroup()).getMyComponentsPages();
                            pages.removeItem(11, pI);
                            pages.insertCodeSnippet(item, (String)locs.first, (String)locs.second, true);
                        }
                    }
                    catch (Exception e) {
                        Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
                    }
                    return true;
                }
                if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String snippet = String.valueOf(dtde.getTransferable().getTransferData(DataFlavor.stringFlavor));
                        if (snippet != null && snippet.length() > 0) {
                            return ui.showCodeSnippetDialog(snippet);
                        }
                    }
                    catch (Exception e) {
                        Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
                    }
                }
            }
            return false;
        }
    }

    private static class FavoritesBehavior
    extends Behavior {
        private FavoritesBehavior() {
        }

        @Override
        public boolean isDropTarget() {
            return true;
        }

        @Override
        public String getMessageText() {
            return PaletteArb.getString(13);
        }

        @Override
        public boolean willAccept(DropTargetDragEvent dtde) {
            if (dtde.getDropAction() == 1 && dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                try {
                    Object data = dtde.getTransferable().getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                    if (data instanceof PaletteItem) {
                        return true;
                    }
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
                }
            }
            return false;
        }

        @Override
        public boolean didAccept(DropTargetDropEvent dtde, MyComponentsGroupUI ui) {
            if (dtde.getDropAction() == 1 && dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                try {
                    Object data = dtde.getTransferable().getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                    if (data instanceof PaletteItem) {
                        PaletteItem item = (PaletteItem)data;
                        Pair locs = ui.determineInsertLocation(dtde.getLocation());
                        Pair augText = ui.getAugmentedText(item);
                        MyComponentsPages pages = ((MyComponentsGroup)ui.getPaletteGroup()).getMyComponentsPages();
                        pages.removeItem(7, item);
                        pages.insertFavorites(item, (String)augText.first, (String)augText.second, (String)locs.first, (String)locs.second, true);
                        return true;
                    }
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
                }
            }
            return false;
        }
    }

    private static abstract class Behavior {
        private Behavior() {
        }

        public abstract boolean isDropTarget();

        public abstract String getMessageText();

        public abstract boolean willAccept(DropTargetDragEvent var1);

        public abstract boolean didAccept(DropTargetDropEvent var1, MyComponentsGroupUI var2);
    }
}

