/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ideimpl.palette2.DeclaredExtension;
import oracle.ideimpl.palette2.DeclaredSection;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class DeclaredGroup
extends HashStructureAdapter
implements DeclaredExtension {
    private DeclaredGroup(HashStructure hash) {
        super(hash);
    }

    public static DeclaredGroup getInstance(HashStructure hash) {
        return new DeclaredGroup(hash);
    }

    public String getName() {
        return this._hash.getString("name/#text");
    }

    public String getDescription() {
        return this._hash.getString("description/#text");
    }

    public String getIcon() {
        return this._hash.getString("icon/#text");
    }

    public String getGroupId() {
        return this._hash.getString("groupId/#text");
    }

    public String getGroupEditor() {
        return this._hash.getString("groupEditor/#text");
    }

    public String getProjectConfiguration() {
        return this._hash.getString("projectConfiguration/#text");
    }

    public List<String> getShowForTypes() {
        List data = this._hash.getAsList("showForTypes");
        if (data == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("type");
            for (HashStructure h2 : data2) {
                types.add(h2.getString("#text"));
            }
        }
        return Collections.unmodifiableList(types);
    }

    public List<String> getTechnologyScopes() {
        List data = this._hash.getAsList("technologyScopes");
        if (data == null) {
            return null;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("technologyScope");
            for (HashStructure h2 : data2) {
                scopes.add(h2.getString("#text"));
            }
        }
        return Collections.unmodifiableList(scopes);
    }

    public String getType() {
        return this._hash.getString("type/#text");
    }

    public String getLayout() {
        return this._hash.getString("layout/#text");
    }

    public Collection<DeclaredSection> getSections() {
        List data = this._hash.getAsList("section");
        if (data != null) {
            ArrayList<DeclaredSection> sections = new ArrayList<DeclaredSection>(data.size());
            for (HashStructure h : data) {
                sections.add(DeclaredSection.getInstance(h));
            }
            return Collections.unmodifiableList(sections);
        }
        return null;
    }

    public String toString() {
        String temp = String.format("DeclaredGroup[ name=%s, description=%s, groupId=%s, ShowForTypes=%s, TechnologyScope=%s, Type=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getDescription()), String.valueOf(this.getGroupId()), String.valueOf(this.getShowForTypes()), String.valueOf(this.getTechnologyScopes()), String.valueOf(this.getType()));
        Collection<DeclaredSection> sections = this.getSections();
        for (DeclaredSection x : sections) {
            temp = temp + x.toString();
        }
        return temp;
    }

    @Override
    public String getExtensionId() {
        return this._hash.getString("#__extension-id");
    }

    public static class GroupBuilder
    extends DefaultPaletteGroup.Builder {
        public GroupBuilder(DeclaredGroup group) {
            super(group.getName(), group.getDescription());
            this.iconUrl(group.getIcon());
            this.groupId(group.getGroupId());
            this.groupEditor(group.getGroupEditor());
            this.projectConfiguration(group.getProjectConfiguration());
            this.showForTypes(group.getShowForTypes());
            this.technologyScopes(group.getTechnologyScopes());
            this.type(group.getType());
            this.extensionId(group.getExtensionId());
            this.layout(group.getLayout());
        }
    }
}

