/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;

public abstract class PaletteLayout<L extends LayoutManager>
implements LayoutManager2,
KeyListener {
    public static Class<? extends PaletteGroupUI> PALETTE_GROUP_UI_KEY = PaletteGroupUI.class;
    public static Class<? extends PaletteSectionUI> PALETTE_SECTION_UI_KEY = PaletteSectionUI.class;
    protected static final float SEPARATOR_HEIGHT_FUDGE_FACTOR = 1.2f;
    protected static final float SEPARATOR_WIDTH_FUDGE_FACTOR = 1.5f;
    protected static final int DEFAULT_SEPARATOR_HEIGHT = 40;
    protected L impl;
    private Container current;

    public PaletteLayout(L impl) {
        if (null == impl) {
            throw new IllegalArgumentException("Base layout implementation must not be null");
        }
        this.impl = impl;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.configureComponent(comp);
        if (this.impl instanceof LayoutManager2) {
            ((LayoutManager2)this.impl).addLayoutComponent(comp, constraints);
        } else {
            this.impl.addLayoutComponent(String.valueOf(constraints), comp);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        if (this.impl instanceof LayoutManager2) {
            return ((LayoutManager2)this.impl).getLayoutAlignmentX(target);
        }
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        if (this.impl instanceof LayoutManager2) {
            return ((LayoutManager2)this.impl).getLayoutAlignmentY(target);
        }
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        Component[] components;
        for (Component comp : components = target.getComponents()) {
            this.addLayoutComponent(comp, null);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        if (this.impl instanceof LayoutManager2) {
            return ((LayoutManager2)this.impl).maximumLayoutSize(target);
        }
        return this.impl.preferredLayoutSize(target);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.configureComponent(comp);
        this.impl.addLayoutComponent(name, comp);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.impl.layoutContainer(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.impl.minimumLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension preferredSize = this.impl.preferredLayoutSize(parent);
        if (parent instanceof JComponent) {
            PaletteGroupUI groupUI = this.getGroupUI((JComponent)parent);
            Component gui = groupUI.getGUI();
            Dimension uiSize = gui.getSize();
            if (gui instanceof JScrollPane) {
                uiSize = ((JScrollPane)gui).getViewport().getExtentSize();
            }
            preferredSize.width = uiSize.width;
        }
        return preferredSize;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.impl.removeLayoutComponent(comp);
    }

    private void configureComponent(Component comp) {
        Object property;
        if (null == comp) {
            return;
        }
        if (comp instanceof PaletteItemUI) {
            this.configurePaletteItemUI((PaletteItemUI)comp);
        }
        if (comp instanceof JComponent && (property = ((JComponent)comp).getClientProperty(PALETTE_SECTION_UI_KEY)) instanceof PaletteSectionUI) {
            this.configurePaletteSectionUI((PaletteSectionUI)property);
        }
    }

    protected abstract void configurePaletteItemUI(PaletteItemUI var1);

    protected abstract void configurePaletteSectionUI(PaletteSectionUI var1);

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (0 != e.getModifiers()) {
            return;
        }
        PaletteItemUI current = (PaletteItemUI)SwingUtilities.getAncestorOfClass(PaletteItemUI.class, e.getComponent());
        if (null == current) {
            return;
        }
        PaletteItemUI next = null;
        switch (e.getKeyCode()) {
            case 38: {
                next = this.getItemAbove(current);
                break;
            }
            case 40: {
                next = this.getItemBelow(current);
                break;
            }
            case 37: {
                next = this.getItemBefore(current);
                break;
            }
            case 39: {
                next = this.getItemAfter(current);
                break;
            }
            default: {
                return;
            }
        }
        if (null != next && current != next) {
            next.requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected PaletteItemUI getItemAbove(PaletteItemUI current) {
        return current;
    }

    protected PaletteItemUI getItemBelow(PaletteItemUI current) {
        return current;
    }

    protected PaletteItemUI getItemBefore(PaletteItemUI current) {
        if (null == current) {
            return null;
        }
        int index = this.indexOf(current);
        if (index <= 0) {
            return current;
        }
        Container parent = current.getParent();
        int count = parent.getComponentCount();
        int i = Math.max(0, index - 1);
        Component comp = parent.getComponent(i);
        if (comp instanceof JLabel) {
            comp = parent.getComponent(i == 0 ? ++i : --i);
        }
        while (!(comp instanceof PaletteItemUI) && i < count) {
            comp = parent.getComponent(++i);
        }
        return comp instanceof PaletteItemUI ? (PaletteItemUI)comp : current;
    }

    protected PaletteItemUI getItemAfter(PaletteItemUI current) {
        int count;
        int i;
        if (null == current) {
            return null;
        }
        int index = this.indexOf(current);
        Container parent = current.getParent();
        Component comp = parent.getComponent(i = Math.min((count = parent.getComponentCount()) - 1, index + 1));
        if (comp instanceof JLabel) {
            comp = parent.getComponent(++i);
        }
        while (!(comp instanceof PaletteItemUI) && i >= 0) {
            comp = parent.getComponent(--i);
        }
        return comp instanceof PaletteItemUI ? (PaletteItemUI)comp : current;
    }

    protected int indexOf(PaletteItemUI itemUI) {
        Container parent = itemUI.getParent();
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (itemUI != parent.getComponent(i)) continue;
            return i;
        }
        return -1;
    }

    protected PaletteGroupUI getGroupUI(JComponent component) {
        if (null == component) {
            return null;
        }
        Object property = component.getClientProperty(PALETTE_GROUP_UI_KEY);
        if (null == property || !PALETTE_GROUP_UI_KEY.isInstance(property)) {
            return null;
        }
        return PALETTE_GROUP_UI_KEY.cast(property);
    }
}

