/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONProperty;
import oracle.dbtools.json.JSONValue;

public class JSONObject
extends JSONNode
implements Iterable<JSONProperty> {
    private final Map<QName, JSONProperty> properties = new LinkedHashMap<QName, JSONProperty>();

    public JSONObject() {
        super(JSONNode.Type.OBJECT);
    }

    @Override
    public Iterator<JSONProperty> iterator() {
        return this.properties().iterator();
    }

    public Collection<JSONProperty> properties() {
        return this.properties.values();
    }

    public JSONProperty property(QName name) {
        return this.properties.get(name);
    }

    public String toString() {
        return JSONBuilder.render(this);
    }

    public void add(QName name, JSONValue<?> value) {
        this.properties.put(name, new JSONProperty(name, value));
    }
}

