/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Readers;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.json.JSONEncoder;
import oracle.dbtools.json.JSONIOExceptionImpl;
import oracle.dbtools.json.JSONRenderer;

public class JSONFormatter
implements Closeable,
JSONRenderer {
    private final Deque<NodeState> state = new ArrayDeque<NodeState>();
    private final Appendable w;
    private static final String QUOTE = "\"";
    private static final QName TEXT = new QName("$t");

    public JSONFormatter(Appendable stream) {
        this.w = stream;
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Object)this.w);
    }

    @Override
    public void end() {
        if (this.pop(NodeType.OBJECT)) {
            this._closeBrace();
            this.hasPrevious(true);
        }
    }

    @Override
    public void endArray() {
        if (this.pop(NodeType.ARRAY)) {
            this._closeArray();
            this.hasPrevious(true);
        }
    }

    @Override
    public void flush(boolean endOfStream) {
        if (endOfStream) {
            while (!this.state.isEmpty()) {
                NodeType type = this.state.peek().type;
                if (NodeType.OBJECT == type) {
                    this.end();
                    continue;
                }
                this.endArray();
            }
        }
        if (this.w instanceof Flushable) {
            try {
                ((Flushable)((Object)this.w)).flush();
            }
            catch (IOException e) {
                throw JSONIOExceptionImpl.wrap(e);
            }
        }
    }

    @Override
    public void name(QName name) {
        this.checkForPrevious();
        StringBuilder n = new StringBuilder();
        String prefix = name.getPrefix();
        String localPart = name.getLocalPart();
        if (!NullOrEmpty.nullOrEmpty((CharSequence)prefix)) {
            n.append(prefix);
            n.append("$");
        }
        n.append(localPart);
        this._quote();
        this._escape(n);
        this._colon();
        this.previousName(n.toString());
    }

    @Override
    public void property(QName name, CharSequence value) {
        this.name(name);
        this.value(value);
    }

    @Override
    public void start() {
        String name = "";
        if (!this.state.isEmpty()) {
            NodeState state = this.state.peek();
            name = state.previousName;
            if (state.hasPrevious) {
                this._comma();
            }
        }
        this._openBrace();
        this.push(NodeType.OBJECT, name);
    }

    @Override
    public void startArray() {
        String name = "";
        if (!this.state.isEmpty()) {
            name = this.state.peek().previousName;
        }
        this._openArray();
        this.push(NodeType.ARRAY, name);
    }

    @Override
    public void text(CharSequence text) {
        this.property(TEXT, text);
    }

    public String toString() {
        return "(state=" + this.state + ", w=<<" + this.w + ">>)";
    }

    @Override
    public void value(Boolean value) {
        if (value == null) {
            this._value(null);
        } else {
            this._value(this.toReader(value));
        }
    }

    @Override
    public void value(CharSequence value) {
        this.value(Readers.reader((CharSequence)value));
    }

    @Override
    public void value(Number value) {
        if (value == null) {
            this._value(null);
        } else {
            String text = JSONFormatter.string(value);
            this._value(Readers.reader((CharSequence)text));
        }
    }

    @Override
    public void value(Reader value) {
        if (value == null) {
            this._value(null);
        } else {
            CharSequence encoded = JSONEncoder.encode(value);
            StringBuilder quoted = new StringBuilder(encoded.length() + 2);
            quoted.append(QUOTE);
            quoted.append(encoded);
            quoted.append(QUOTE);
            this._value(Readers.reader((CharSequence)quoted));
        }
    }

    private void _closeArray() {
        this.print("]");
    }

    private void _closeBrace() {
        this.print("}");
    }

    private void _colon() {
        this.print("\":");
    }

    private void _comma() {
        this.print(",");
    }

    private void _escape(CharSequence value) {
        this.print(JSONEncoder.encode(Readers.reader((CharSequence)value)));
    }

    private void _null() {
        this.print("null");
    }

    private void _openArray() {
        this.print("[");
    }

    private void _openBrace() {
        this.print("{");
    }

    private void _quote() {
        this.print(QUOTE);
    }

    private void _value(Readable value) {
        boolean nullValue = null == value;
        this.checkForPrevious();
        if (nullValue) {
            this._null();
        } else {
            try {
                StreamCopy.drain((Readable)value, (Appendable)this.w);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.hasPrevious(true);
    }

    private void checkForPrevious() {
        boolean doComma = false;
        if (!this.state.isEmpty()) {
            NodeState state = this.state.peek();
            if (state.hasPrevious) {
                doComma = true;
            }
        }
        if (doComma) {
            this._comma();
            this.hasPrevious(false);
        }
    }

    private void hasPrevious(boolean value) {
        if (!this.state.isEmpty()) {
            this.state.peek().hasPrevious = value;
        }
    }

    private boolean pop(NodeType expected) {
        if (this.state.isEmpty()) {
            throw new IllegalStateException("Expected: " + (Object)((Object)expected) + " on stack, but stack was empty");
        }
        NodeState actual = this.state.pop();
        if (expected == actual.type) {
            return true;
        }
        throw new IllegalStateException("Expected: " + (Object)((Object)expected) + " on stack, but popped: " + (Object)((Object)actual.type));
    }

    private void previousName(String name) {
        if (!this.state.isEmpty()) {
            this.state.peek().previousName = name;
        }
    }

    private void print(CharSequence s) {
        try {
            this.w.append(s);
        }
        catch (IOException e) {
            throw JSONIOExceptionImpl.wrap(e);
        }
    }

    private void push(NodeType type, String name) {
        this.state.push(new NodeState(type, name));
    }

    private Reader toReader(boolean value) {
        return value ? Readers.reader((CharSequence)"true") : Readers.reader((CharSequence)"false");
    }

    private static String string(Number value) {
        double d;
        boolean quote = false;
        String text = PrimitiveTypes.string((Object)value);
        if (value != null && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            quote = true;
        }
        if (quote) {
            text = QUOTE + text + QUOTE;
        }
        return text;
    }

    private static enum NodeType {
        ARRAY,
        OBJECT;

    }

    private static final class NodeState {
        boolean hasPrevious = false;
        transient String previousName = "";
        private final String name;
        private final NodeType type;

        NodeState(NodeType type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (!this.name.isEmpty()) {
                b.append(this.name);
                b.append(": ");
            }
            b.append(this.type == NodeType.ARRAY ? "[...]" : "{...}");
            return b.toString();
        }
    }
}

