/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.uri.URISandbox;
import oracle.dbtools.common.util.FilePathSyntax;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Projects;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.locale.LocalePreference;

public abstract class StaticContent {
    private static final Log LOG = Log.get(StaticContent.class);
    private static final Set<URI> SEARCH_LOCATIONS = new LinkedHashSet<URI>();
    private static boolean searchStatic = false;
    private static final String STATIC_PATH = "../static/src/main/resources/";
    private static final String STATIC_PREFIX = "www/";

    private StaticContent() {
    }

    public static void setup(boolean searchStatic) {
        StaticContent.reset();
        StaticContent.searchStatic = searchStatic;
    }

    public static URI uri(LocalePreference localePreference, String resourcePath) {
        URI uri = null;
        if (FilePathSyntax.isValid((CharSequence)resourcePath, (boolean)true)) {
            URI root;
            Iterator<URI> i$ = SEARCH_LOCATIONS.iterator();
            while (i$.hasNext() && (uri = StaticContent.search(localePreference, root = i$.next(), resourcePath)) == null) {
            }
            if (uri == null && searchStatic) {
                uri = StaticContent.search(localePreference, StaticContent.staticResources(), resourcePath);
            }
        }
        return uri;
    }

    protected static URI search(LocalePreference localePreference, URI root, String resourcePath) {
        URIs.Status status;
        URI uri = null;
        URI l8nRoot = localePreference.choose(root);
        URISandbox sandbox = URISandbox.sandbox((URI)l8nRoot);
        URI resource = sandbox.uri(resourcePath);
        if (resource != null && URIs.Status.DOES_NOT_EXIST != (status = URIs.status((URI)resource))) {
            uri = resource;
        }
        return uri;
    }

    static void addLocation(URI location) {
        URI staticLocation = StaticContent.staticLocation(location);
        if (URIs.exists((URI)staticLocation)) {
            SEARCH_LOCATIONS.add(staticLocation);
        }
    }

    static void reset() {
        searchStatic = false;
        LocalePreference.reset();
        SEARCH_LOCATIONS.clear();
        try {
            Enumeration<URL> cpRoots = Thread.currentThread().getContextClassLoader().getResources(STATIC_PREFIX);
            while (cpRoots.hasMoreElements()) {
                URI uri;
                boolean exists;
                URL cpRoot = cpRoots.nextElement();
                if (cpRoot == null || !(exists = URIs.exists((URI)(uri = cpRoot.toURI())))) continue;
                SEARCH_LOCATIONS.add(uri);
            }
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable((Throwable)e);
        }
    }

    static void setup() {
        StaticContent.setup(true);
    }

    public static void teardown() {
        StaticContent.reset();
    }

    private static URI staticLocation(URI location) {
        return URIs.resolve((URI)location, (String)STATIC_PREFIX);
    }

    private static URI staticResources() {
        try {
            File project = Projects.project(StaticContent.class);
            File absPath = new File(project, STATIC_PATH).getCanonicalFile();
            return Files.uri((File)Files.file((File)absPath, (String)STATIC_PREFIX));
        }
        catch (IOException e) {
            LOG.severe((Throwable)e);
            throw UnrecoverableException.unrecoverable((Throwable)e);
        }
    }

    static {
        StaticContent.reset();
    }
}

