/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.lang.management.ManagementFactory;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.common.util.Log;
import sun.awt.AppContext;

class PermGenLeaks {
    private static final Log LOG = Log.get(PermGenLeaks.class);

    PermGenLeaks() {
    }

    static synchronized void setup() {
        PermGenLeaks.contextClassLoaderOffenders();
    }

    static synchronized void teardown() {
        PermGenLeaks.deregisterJDBCDrivers();
        PermGenLeaks.deregisterMBeans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void contextClassLoaderOffenders() {
        ClassLoader active = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader root = PermGenLeaks.rootClassLoader();
            Thread.currentThread().setContextClassLoader(root);
            PermGenLeaks.sunAwtAppContext(root);
            PermGenLeaks.documentBuilderFactory(root);
            PermGenLeaks.jaasConfiguration(root);
        }
        finally {
            Thread.currentThread().setContextClassLoader(active);
        }
    }

    private static void deregisterJDBCDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!PermGenLeaks.isLoadedByWebApp(driver)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (Throwable t) {
                LOG.fine(t);
            }
        }
    }

    private static void deregisterMBeans() {
        ClassLoader webAppClassLoader = PermGenLeaks.webAppClassLoader();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> allMBeanNames = mBeanServer.queryNames(new ObjectName("*:*"), null);
            for (ObjectName objectName : allMBeanNames) {
                try {
                    ClassLoader mBeanClassLoader = mBeanServer.getClassLoaderFor(objectName);
                    if (!PermGenLeaks.withinClassLoader(webAppClassLoader, mBeanClassLoader)) continue;
                    mBeanServer.unregisterMBean(objectName);
                }
                catch (Throwable t) {
                    LOG.fine(t);
                }
            }
        }
        catch (Throwable t) {
            LOG.fine(t);
        }
    }

    private static void documentBuilderFactory(ClassLoader root) {
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Throwable t) {
            LOG.fine("Failed to apply the javax.xml.parsers.DocumentBuilderFactory PermGen leak counter-measure");
            LOG.fine(t);
        }
    }

    private static boolean isLoadedByWebApp(Object instance) {
        return instance != null && instance.getClass().getClassLoader() == Thread.currentThread().getContextClassLoader();
    }

    private static void jaasConfiguration(ClassLoader root) {
        try {
            Class.forName("javax.security.auth.login.Configuration", true, root);
        }
        catch (Throwable t) {
            LOG.fine("Failed to apply the javax.security.auth.login.Configuration PermGen leak counter-measure");
            LOG.fine(t);
        }
    }

    private static ClassLoader rootClassLoader() {
        ClassLoader root = Thread.currentThread().getContextClassLoader();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    private static void sunAwtAppContext(ClassLoader root) {
        try {
            AppContext.getAppContext();
        }
        catch (Throwable t) {
            LOG.fine("Failed to apply the sun.awt.AppContext PermGen leak counter-measure");
            LOG.fine(t);
        }
    }

    private static ClassLoader webAppClassLoader() {
        return PermGenLeaks.class.getClassLoader();
    }

    private static boolean withinClassLoader(ClassLoader scope, ClassLoader classLoader) {
        for (ClassLoader current = classLoader; current != null; current = current.getParent()) {
            if (current != scope) continue;
            return true;
        }
        return false;
    }
}

