/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.Map;
import oracle.dbtools.common.headers.HttpHeaderValue;
import oracle.dbtools.common.util.CharSequenceMixin;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.CustomHttpHeader;
import oracle.dbtools.rt.web.RequestEntity;

public class AcceptFormatting
extends CharSequenceMixin {
    private final Map<CharSequence, CharSequence> parameters;
    private static final AcceptFormatting NO_PARAMETERS = new AcceptFormatting("");

    private AcceptFormatting(CharSequence text) {
        super(text);
        this.parameters = HttpHeaderValue.parse((CharSequence)text).asMap();
    }

    public Map<CharSequence, CharSequence> parameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AcceptFormatting other = (AcceptFormatting)((Object)obj);
        return this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public static AcceptFormatting contentFormatting(RequestEntity request) {
        EntityHeader contentFormatting = request.headers().header(CustomHttpHeader.ACCEPT_FORMATTING);
        if (contentFormatting == null) {
            return AcceptFormatting.parse(null);
        }
        return AcceptFormatting.parse(contentFormatting.value());
    }

    public static AcceptFormatting parse(CharSequence text) {
        if (NullOrEmpty.nullOrEmpty((CharSequence)text)) {
            return NO_PARAMETERS;
        }
        return new AcceptFormatting(text);
    }
}

