/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.uri;

import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.uri.PathMatcher;

public abstract class PathMatchers {
    private PathMatchers() {
    }

    public static PathMatcher compose(Iterable<PathMatcher> pathMatchers) {
        return new Composite(pathMatchers);
    }

    public static PathMatcher compose(PathMatcher ... pathMatchers) {
        return PathMatchers.compose(Iterables.iterable((Object[])pathMatchers));
    }

    private static class Composite
    implements PathMatcher {
        private final Iterable<PathMatcher> pathMatchers;

        private Composite(Iterable<PathMatcher> pathMatchers) {
            this.pathMatchers = pathMatchers;
        }

        @Override
        public boolean matches(String path) {
            for (PathMatcher pathMatcher : this.pathMatchers) {
                boolean match = pathMatcher.matches(path);
                if (!match) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return Iterables.join(this.pathMatchers, (String)", ");
        }
    }
}

