/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.session;

import java.io.Serializable;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;

public class SessionState
implements Serializable {
    private final long created;
    private final String csrfToken;
    private final String logonRealmId;
    private final String startPath;
    private final Serializable state;
    public static final String SESSION_ATTRIBUTE_NAME = "_com.oracle.al";
    private static final String REAUTH_KEY = "_auth_";
    private static final String REAUTH_VALUE = "force";
    private static final long serialVersionUID = -4561416648997886934L;

    private SessionState(String startPath, LogonRealm realm, Serializable state) {
        this.logonRealmId = realm.id();
        this.startPath = startPath;
        this.state = state;
        this.csrfToken = Identifiers.randomIdentifier();
        this.created = System.currentTimeMillis();
    }

    public boolean authenticated() {
        return this.state instanceof CompoundPrincipal;
    }

    public String csrfToken() {
        return this.csrfToken;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionState other = (SessionState)obj;
        if (this.created != other.created) {
            return false;
        }
        if (this.csrfToken == null ? other.csrfToken != null : !this.csrfToken.equals(other.csrfToken)) {
            return false;
        }
        if (this.logonRealmId == null ? other.logonRealmId != null : !this.logonRealmId.equals(other.logonRealmId)) {
            return false;
        }
        if (this.startPath == null ? other.startPath != null : !this.startPath.equals(other.startPath)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (this.csrfToken == null ? 0 : this.csrfToken.hashCode());
        result = 31 * result + (this.logonRealmId == null ? 0 : this.logonRealmId.hashCode());
        result = 31 * result + (this.startPath == null ? 0 : this.startPath.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public LogonRealm logonRealm() {
        return LogonRealm.realm(this.logonRealmId);
    }

    public CompoundPrincipal principal() {
        if (this.state instanceof CompoundPrincipal) {
            return (CompoundPrincipal)this.state;
        }
        throw new IllegalStateException();
    }

    public String startPath() {
        return this.startPath;
    }

    public Serializable state() {
        return this.state;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionState [logonRealmId=");
        builder.append(this.logonRealmId);
        builder.append(", startPath=");
        builder.append(this.startPath);
        builder.append(", created=");
        builder.append(this.created);
        builder.append(", csrfToken=");
        builder.append(this.csrfToken);
        builder.append(", state=");
        builder.append(this.state);
        builder.append("]");
        return builder.toString();
    }

    public static SessionState authenticatedSession(String startPath, LogonRealm realm, CompoundPrincipal principal) {
        return new SessionState(startPath, realm, (Serializable)principal);
    }

    public static boolean authenticationRequired(RequestPaths requestPaths) {
        return SessionState.authenticationRequired(requestPaths.path());
    }

    public static boolean authenticationRequired(String requestPath) {
        QueryString queryString;
        String reauth;
        return requestPath != null && (reauth = (String)(queryString = QueryString.parse((String)requestPath)).get((Object)REAUTH_KEY)) != null && REAUTH_VALUE.equals(reauth);
    }

    public static LogonRealm logonRealm(RequestEntity request) {
        SessionState session = SessionState.session(request);
        if (session != null) {
            return session.logonRealm();
        }
        return LogonRealm.realm(request);
    }

    public static String removeAuthenticationForceFlag(String path) {
        if (path == null) {
            return null;
        }
        QueryString parsed = QueryString.parse((String)path);
        QueryString modified = parsed.remove(REAUTH_KEY, REAUTH_VALUE);
        return modified.toString();
    }

    public static SessionState session(RequestEntity request) {
        if (SessionState.authenticationRequired(request)) {
            Requests.invalidateSession(request);
            return null;
        }
        return (SessionState)Requests.sessionAttribute(request, SESSION_ATTRIBUTE_NAME);
    }

    public static String startPath(RequestEntity request) {
        SessionState session = SessionState.session(request);
        if (session != null) {
            return session.startPath();
        }
        return null;
    }

    public static SessionState unauthenticatedSession(String startPath, LogonRealm realm, Serializable state) {
        return new SessionState(startPath, realm, state);
    }
}

