/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class ResourceParameter {
    private ParameterAccess access;
    private String aliasing;
    private Kind kind;
    private String name;
    private String primitiveType;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceParameter [bindName=");
        builder.append(this.name);
        builder.append(", originalName=");
        builder.append(this.aliasing);
        builder.append(", kind=");
        builder.append((Object)this.kind);
        builder.append(", access=");
        builder.append(this.access);
        builder.append(", primitiveType=");
        builder.append(this.primitiveType);
        builder.append("]");
        return builder.toString();
    }

    public ResourceParameter(Kind type, String bindName, String originalName, Class<?> classOf, ParameterAccess access) {
        this.kind = type;
        this.name = bindName;
        this.aliasing = originalName;
        this.primitiveType = classOf.getName();
        this.access = access;
    }

    private ResourceParameter() {
    }

    public ParameterAccess access() {
        return this.access;
    }

    public String originalName() {
        return this.aliasing == null ? this.name : this.aliasing;
    }

    public Kind kind() {
        return this.kind;
    }

    public String bindName() {
        return this.name;
    }

    public Class<?> primitiveType() {
        try {
            return Class.forName(this.primitiveType);
        }
        catch (ClassNotFoundException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public static enum Kind {
        HEADER,
        URI;


        public static Kind value(String text) {
            if ("RESPONSE".equals(text)) {
                return URI;
            }
            return Kind.valueOf(text);
        }
    }
}

