/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityCollectionRequestHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModuleReader;
import oracle.dbtools.rt.resource.templates.v2.ResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ResourceModulesRequestHandler
extends TenantEntityCollectionRequestHandler {
    @Reference
    private ResourceModules modules;
    @Reference
    private Validator validator;
    private static ContentType CONTENT_TYPE = ResourceTemplatesProfile.MEDIA_TYPE;

    public ResourceModulesRequestHandler() {
        super(ResourceTemplatesProfile.URI_TEMPLATES, CONTENT_TYPE);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ResourceModuleReader(this.validator);
    }

    @Override
    protected Iterator<FeedItem> items(Transaction txn, final RequestEntity request) {
        return Iterators.transform(this.modules.modules(txn, request.principal()).iterator(), (Transform)new Transform<ResourceModule, FeedItem>(){

            public FeedItem apply(final ResourceModule module) {
                return new FeedItem(){

                    @Override
                    public String id() {
                        return TenantIdentifiers.string(request.principal(), module.id());
                    }

                    @Override
                    public ResultRow item() {
                        return ResultRows.row((String[])new String[]{"title"}, (Object[])new String[]{module.name()});
                    }
                };
            }
        });
    }

    @Override
    protected Transaction transaction(CompoundPrincipal principal) {
        return this.modules.newTransaction(principal);
    }
}

