/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandlers;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModuleWriter;
import oracle.dbtools.rt.resource.templates.v2.ResourceModulesProvider;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplates;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ResourceModules.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.EntityStorage", value="oracle.dbtools.rt.resource.templates.v2.ResourceModule")})
public class ResourceModules
implements ResourceModulesProvider {
    @Reference
    private ResourceHandlers handlers;
    @Reference
    private ResourceModulesProvider provider;
    @Reference
    private ResourceTemplates templates;

    public InputStream content(CompoundPrincipal principal, ResourceModule existing) {
        try {
            return new ResourceModuleWriter(this.provider, this.templates).content(principal, existing);
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        this.provider.delete(txn, principal, entityId);
    }

    @Override
    public Iterable<ResourceModule> entities(Transaction txn, CompoundPrincipal principal) {
        return this.provider.entities(txn, principal);
    }

    @Override
    public ResourceModule entity(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        return (ResourceModule)this.provider.entity(txn, principal, entityId);
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.provider.newTransaction(principal);
    }

    @Override
    public Iterable<ResourceModule> modules(Transaction txn, CompoundPrincipal principal) {
        return this.provider.modules(txn, principal);
    }

    @Override
    public Iterable<ResourceTemplate> children(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        return this.provider.children(txn, principal, id);
    }

    @Override
    public ResourceModule insert(Transaction txn, CompoundPrincipal principal, ResourceModule instance) {
        return this.provider.insert(txn, principal, instance);
    }

    @Override
    public ResourceModule update(Transaction txn, CompoundPrincipal principal, ResourceModule instance) {
        return this.provider.update(txn, principal, instance);
    }
}

