/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityBase;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;

public class ResourceModule
extends TenantEntityBase
implements TenantEntity {
    private String comments;
    private int itemsPerPage;
    private String name = "(default)";
    private String[] originsAllowed;
    private String parsingSchema;
    private Https requireHttps = Https.YES;
    private PublishedState status = PublishedState.NOT_PUBLISHED;
    private String uriPrefix;
    private static final String DEFAULT_MODULE_NAME = "(default)";

    public String comments() {
        return this.comments;
    }

    public ResourceModule comments(String comments) {
        this.comments = comments;
        return this;
    }

    public void defaultModule() {
        this.name(DEFAULT_MODULE_NAME);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceModule other = (ResourceModule)obj;
        if (this.itemsPerPage != other.itemsPerPage) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.originsAllowed, other.originsAllowed)) {
            return false;
        }
        if (this.parsingSchema == null ? other.parsingSchema != null : !this.parsingSchema.equals(other.parsingSchema)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.uriPrefix == null ? other.uriPrefix != null : !this.uriPrefix.equals(other.uriPrefix));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.itemsPerPage;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.originsAllowed);
        result = 31 * result + (this.parsingSchema == null ? 0 : this.parsingSchema.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.uriPrefix == null ? 0 : this.uriPrefix.hashCode());
        return result;
    }

    public int itemsPerPage() {
        return this.itemsPerPage;
    }

    public void itemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public List<String> originsAllowed() {
        return this.originsAllowed == null ? Collections.emptyList() : Arrays.asList(this.originsAllowed);
    }

    public void orignsAllowed(String ... originsAllowed) {
        this.originsAllowed = originsAllowed;
    }

    @Override
    public TenantIdentifier parentId() {
        return TenantIdentifier.NO_PARENT;
    }

    @Override
    public void parentId(TenantIdentifier templateId) {
    }

    public String parsingSchema() {
        return this.parsingSchema;
    }

    public ResourceModule parsingSchema(String parsingSchema) {
        this.parsingSchema = parsingSchema;
        return this;
    }

    public boolean published() {
        return PublishedState.PUBLISHED == this.status;
    }

    public void published(boolean published) {
        this.status = published ? PublishedState.PUBLISHED : PublishedState.NOT_PUBLISHED;
    }

    public Https requireHttps() {
        return this.requireHttps;
    }

    public void requireHttps(Https requireHttps) {
        this.requireHttps = requireHttps;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceModule [id=");
        builder.append(this.id());
        builder.append(", itemsPerPage=");
        builder.append(this.itemsPerPage);
        builder.append(", metadata=");
        builder.append(this.metadata());
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", originsAllowed=");
        builder.append(Arrays.toString(this.originsAllowed));
        builder.append(", parsingSchema=");
        builder.append(this.parsingSchema);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", uriPrefix=");
        builder.append(this.uriPrefix);
        builder.append(", comments=");
        builder.append(this.comments);
        builder.append("]");
        return builder.toString();
    }

    public String uriPrefix() {
        return this.uriPrefix;
    }

    public void uriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public static boolean isDefaultModule(ResourceModule module) {
        return DEFAULT_MODULE_NAME.equals(module.name());
    }

    public static enum PublishedState {
        NOT_PUBLISHED,
        PUBLISHED;

    }

    public static enum Https {
        NO,
        YES;

    }
}

