/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceLocatorException;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.jdbc.entity.JDBCNestedEntityProviderBase;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceMetaData;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModulesProvider;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;

@Service(priority=1)
public class JDBCResourceModulesProvider
extends JDBCNestedEntityProviderBase<ResourceModule, ResourceTemplate>
implements ResourceModulesProvider {
    private static final Log LOG = Log.get(JDBCResourceModulesProvider.class);

    public JDBCResourceModulesProvider() {
        super(JDBCResourceMetaData.instance().module(), true);
    }

    @Override
    public Iterable<ResourceModule> modules(Transaction txn, CompoundPrincipal principal) {
        return TenantIdentifiers.removeInternal(this.entities(txn, principal));
    }

    @Override
    protected void deleted(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        this.invalidate(principal, id);
    }

    @Override
    protected ResourceModule updated(Transaction txn, CompoundPrincipal principal, ResourceModule instance) {
        this.invalidate(principal, instance.id());
        return super.updated(txn, principal, instance);
    }

    private void invalidate(CompoundPrincipal principal, TenantIdentifier id) {
        try {
            MetadataCaches caches = (MetadataCaches)ServiceLocator.acquire(MetadataCaches.class);
            MetadataCache cache = caches.getIfPresent(principal);
            if (cache != null) {
                cache.invalidateModule(id);
            }
        }
        catch (ServiceLocatorException e) {
            LOG.finest((Throwable)e);
        }
    }
}

