/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache.sync;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Timestamp;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.cache.CacheConfiguration;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheConfigurations;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;
import oracle.dbtools.rt.resource.templates.cache.sync.MetadataCacheSynchronizer;

@Service
public class MetadataCacheSynchronization {
    private static final Log LOG = Log.get(MetadataCacheSynchronization.class);
    @Reference
    private MetadataCacheConfigurations confs;
    @Reference
    private JDBCCallProvider jdbc;
    private final Cache<String, MetadataCacheSynchronizer> tasks = CacheBuilder.newBuilder().build();
    private static boolean ENABLED = true;

    public void track(final CompoundPrincipal principal, final Timestamp created) {
        if (ENABLED) {
            final MetadataCaches caches = (MetadataCaches)ServiceLocator.acquire(MetadataCaches.class);
            final String poolIdentifier = this.poolIdentifer(principal);
            try {
                this.tasks.get((Object)poolIdentifier, (Callable)new Callable<MetadataCacheSynchronizer>(){

                    @Override
                    public MetadataCacheSynchronizer call() throws Exception {
                        CacheConfiguration cacheConf = MetadataCacheSynchronization.this.confs.resourceModules();
                        MetadataCacheSynchronizer sync = new MetadataCacheSynchronizer(principal, created, cacheConf.syncFrequency(), caches, MetadataCacheSynchronization.this.jdbc);
                        LOG.fine("Tracking change to metadata in pool: " + poolIdentifier + ", every " + cacheConf.syncFrequency());
                        sync.start();
                        return sync;
                    }
                });
            }
            catch (ExecutionException e) {
                LOG.warning((Throwable)e);
            }
        }
    }

    protected void activate(ServiceProperties properties) throws Exception {
        CacheConfiguration cacheConf;
        if (ENABLED && !(cacheConf = this.confs.resourceModules()).enabled()) {
            throw new NotAvailableException(MetadataCacheSynchronization.class);
        }
    }

    protected void deactivate(ServiceProperties props) {
        for (MetadataCacheSynchronizer sync : this.tasks.asMap().values()) {
            Closeables.close((Object)sync);
        }
        this.tasks.invalidateAll();
        this.tasks.cleanUp();
    }

    private String poolIdentifer(CompoundPrincipal principal) {
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        String poolIdentifier = null;
        if (existing == null) {
            throw new IllegalArgumentException();
        }
        poolIdentifier = existing.getName();
        return poolIdentifier;
    }
}

