/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import java.io.IOException;
import oracle.dbtools.cache.CacheConfiguration;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheConfigurations;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesDispatcher;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(priority=2)
public class CachedResourceTemplateDispatcher
implements ResourceDispatcher,
OAuthScopeProvider {
    @Reference
    private MetadataCacheConfigurations cacheConfs;
    @Reference
    private MetadataCaches caches;
    @Reference
    private ResourceTemplatesDispatcher dispatcher;

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        MetadataCache cache = this.tenantCache(request);
        if (cache == null) {
            return ResourceDispatcher.NO_MATCH;
        }
        return this.dispatcher.canDispatch(cache, request);
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        MetadataCache cache = this.tenantCache(request);
        return this.dispatcher.dispatch(cache, score, request);
    }

    @Override
    public TenantIdentifier scopeForPath(CompoundPrincipal principal, String path) {
        MetadataCache cache = this.tenantCache(principal);
        TenantIdentifier scopeId = cache.scopeForPath(path);
        return scopeId;
    }

    protected void activate(ServiceProperties properties) throws Exception {
        CacheConfiguration cacheConf = this.cacheConfs.resourceModules();
        if (!cacheConf.enabled()) {
            throw new NotAvailableException(CachedResourceTemplateDispatcher.class);
        }
    }

    private MetadataCache tenantCache(CompoundPrincipal principal) {
        MetadataCache cache = this.caches.get(principal);
        return cache;
    }

    private MetadataCache tenantCache(RequestEntity request) {
        CompoundPrincipal principal = request.principal();
        return this.tenantCache(principal);
    }
}

