/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import java.util.logging.Level;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.RoleMappers;

class CachedPrivilege {
    private final String name;
    private final transient RoleMappers roleMappings;
    private final Iterable<String> roles;
    private static final Log LOG = Log.get(CachedPrivilege.class);

    CachedPrivilege(RoleMappers roleMappings, String name, Iterable<String> roles) {
        this.roleMappings = roleMappings;
        this.name = name;
        this.roles = roles;
    }

    public AuthorizationPolicy.Access authorize(CompoundPrincipal principal) {
        boolean hasRequiredRole = false;
        for (String requiredRole : this.roles) {
            if (this.roleMappings.isPrincipalInRole(principal, requiredRole)) {
                hasRequiredRole = true;
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.fine("The user: " + principal + " does have the required role: " + requiredRole + " to access: " + this.name);
                break;
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("The user: " + principal + " does not have the required role: " + requiredRole + " to access: " + this.name);
        }
        AuthorizationPolicy.Access access = AuthorizationPolicy.Access.NONE;
        access = hasRequiredRole ? AuthorizationPolicy.Access.READ_WRITE : AuthorizationPolicy.Access.NONE;
        return access;
    }

    public String toString() {
        return "CachedPrivilege [name=" + this.name + ", roles=" + this.roles + "]";
    }
}

