/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection.tenants;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantEntityAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.TenantEntityTreeStorage;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.resource.collection.ItemRequestHandler;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public abstract class TenantEntityItemRequestHandler<T extends TenantEntity>
extends ItemRequestHandler<T> {
    @Reference
    private TenantEntityTreeStorage storage;

    protected TenantEntityItemRequestHandler(CollectionUriTemplates uriTemplates, TenantEntityAccess entityAccess, ContentType ... acceptable) {
        super(uriTemplates, new TenantEntityAuthorizationPolicy(entityAccess), acceptable);
    }

    protected abstract TreeReader<TenantEntity> entityGraphReader();

    @Override
    protected TenantIdentifier id(CompoundPrincipal principal, String idValue) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        return tenant.valueOf(idValue);
    }

    @Override
    protected void put(CompoundPrincipal principal, T existing, ContentType contentType, InputStream content) {
        try {
            Tree tree = this.entityGraphReader().read(principal, content);
            this.put(principal, existing, (Tree<TenantEntity>)tree);
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    protected void put(CompoundPrincipal principal, T existing, Tree<TenantEntity> tree) {
        this.storage.update(principal, existing.id(), tree);
    }

    @Override
    protected String string(CompoundPrincipal principal, TenantIdentifier id) {
        return TenantIdentifiers.string(principal, id);
    }
}

