/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public abstract class ItemRequestHandler<T extends TenantEntity>
extends RequestHandler {
    private final ContentType[] acceptable;
    private final AuthorizationPolicy<T> authorizationPolicy;
    private final URITemplate relativeTemplate;
    private final URITemplate template;

    protected ItemRequestHandler(CollectionUriTemplates uriTemplates, AuthorizationPolicy<T> authorizationPolicy, ContentType ... acceptable) {
        super(ItemRequestHandler.metadata(uriTemplates));
        this.template = uriTemplates.item();
        this.authorizationPolicy = authorizationPolicy;
        this.relativeTemplate = uriTemplates.relativeItem();
        this.acceptable = acceptable;
    }

    public String toString() {
        return "ItemRequestHandler [template=" + this.template + ", authorizationPolicy=" + this.authorizationPolicy + ", acceptable=" + Arrays.toString((Object[])this.acceptable) + "]";
    }

    protected void delete(CompoundPrincipal principal, T existing) {
        throw this.methodNotAllowed(HttpMethod.DELETE);
    }

    @Override
    protected final Entity delete(RequestEntity request) throws IOException {
        T existing;
        CompoundPrincipal principal = request.principal();
        AuthorizationPolicy.Access access = this.authorize((Principal)principal, existing = this.existing(request));
        if (!AuthorizationPolicy.Access.writeAccess(access)) {
            throw WebException.notAuthorized();
        }
        this.delete(principal, existing);
        return HttpResources.NO_CONTENT;
    }

    protected abstract T existing(CompoundPrincipal var1, TenantIdentifier var2);

    @Override
    protected final Entity get(RequestEntity request) throws IOException {
        T existing;
        CompoundPrincipal principal = request.principal();
        AuthorizationPolicy.Access access = this.authorize((Principal)principal, existing = this.existing(request));
        boolean readAccess = AuthorizationPolicy.Access.readAccess(access);
        if (readAccess) {
            return this.process(principal, existing);
        }
        throw WebException.notAuthorized();
    }

    protected abstract TenantIdentifier id(CompoundPrincipal var1, String var2);

    @Override
    @Deprecated
    protected final Entity post(RequestEntity request) throws IOException {
        return super.post(request);
    }

    protected abstract Entity process(CompoundPrincipal var1, T var2);

    protected void put(CompoundPrincipal principal, T existing, ContentType contentType, InputStream body) {
        throw this.methodNotAllowed(HttpMethod.PUT);
    }

    @Override
    protected final Entity put(RequestEntity request) throws IOException {
        T existing;
        CompoundPrincipal principal = request.principal();
        AuthorizationPolicy.Access access = this.authorize((Principal)principal, existing = this.existing(request));
        if (!AuthorizationPolicy.Access.writeAccess(access)) {
            throw WebException.notAuthorized();
        }
        Requests.acceptable(request.contentType(), this.acceptable);
        this.put(principal, existing, request.contentType(), request.body());
        String location = this.relativeTemplate.encode("id", this.string(principal, existing.id()));
        return Entities.entity(null, Entities.headers("X-APEX-FORWARD", location));
    }

    protected String string(CompoundPrincipal principal, TenantIdentifier id) {
        return id.toString();
    }

    private AuthorizationPolicy.Access authorize(Principal principal, T existing) {
        return this.authorizationPolicy.authorize(principal, existing);
    }

    private T existing(RequestEntity request) {
        TenantIdentifier id;
        CompoundPrincipal principal = request.principal();
        T existing = this.existing(principal, id = this.id(request));
        if (existing == null) {
            throw WebException.notFound();
        }
        return existing;
    }

    private TenantIdentifier id(RequestEntity request) {
        Map<String, String> params = this.template.decode(request.path());
        String text = params.get("id");
        TenantIdentifier id = this.id(request.principal(), text);
        return id;
    }

    private static RequestHandlerMetaData metadata(CollectionUriTemplates uriTemplates) {
        return RequestHandlerMetaData.builder(uriTemplates.item(), HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE).securityConfig(SecurityConfigs.SECURE_REST_SERVICE).build();
    }
}

