/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.plsql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.apex.OWA;
import oracle.dbtools.apex.OWAStatement;
import oracle.dbtools.common.app.Version;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCProxyPrincipal;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.jdbc.BindableCallResults;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.ReaderStream;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

class OracleWebAccess {
    private final JDBCCallProvider jdbc;

    OracleWebAccess(JDBCCallProvider jdbc) {
        this.jdbc = jdbc;
    }

    public void init(Transaction txn, RequestEntity request) throws SQLException {
        OWA.Headers hdrs = this.getHeaders(request);
        this.init(txn, hdrs);
    }

    public Entity response(Transaction txn) throws SQLException {
        Entity entity;
        JDBCCall page = null;
        try {
            page = this.jdbc.call(txn, OWAStatement.GET_PAGE.stmt());
            page.bind(Collections.EMPTY_MAP);
            BindableCallResults results = page.execute();
            InputStream content = this.getStream((Map<String, Object>)results);
            if (content == null) {
                content = StreamCopy.toInputStream((CharSequence)((String)results.get("text")));
            }
            EntityHeaders headers = OracleWebAccess.consumeHeaders(content);
            InputStream body = content;
            boolean isFile = Boolean.parseBoolean((String)results.get("is_file"));
            if (isFile) {
                String docInfo = (String)results.get("doc_info");
                body = OracleWebAccess.download(this.jdbc, txn, docInfo);
            }
            entity = Entities.entity(body, headers);
        }
        catch (IOException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(page);
                throw throwable;
            }
        }
        Closeables.close((Object)page);
        return entity;
    }

    private OWA.Headers getHeaders(RequestEntity request) {
        URI uri = URIs.create((String)(request.base() + request.path()));
        String path = URIs.path((URI)uri);
        OWA.Headers _header = new OWA.Headers();
        EntityHeaders hdrs = request.headers();
        for (String name : hdrs) {
            EntityHeader hdr = hdrs.header(name);
            for (String value : hdr.values()) {
                _header.addHeader(name, value);
            }
        }
        _header.addHeader("APEX_LISTENER_VERSION", Version.INSTANCE.getVersion());
        _header.addHeader("DAD_NAME", "");
        _header.addHeader("DOC_ACCESS_PATH", "");
        _header.addHeader("DOCUMENT_TABLE", "");
        _header.addHeader("GATEWAY_IVERSION", "3");
        _header.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        _header.addHeader("HTTP_ACCEPT", OracleWebAccess.value(hdrs, "accept"));
        _header.addHeader("HTTP_ACCEPT_ENCODING", OracleWebAccess.value(hdrs, "accept-encoding"));
        _header.addHeader("HTTP_ACCEPT_LANGUAGE", OracleWebAccess.value(hdrs, "accept-language"));
        _header.addHeader("HTTP_ACCEPT_CHARSET", OracleWebAccess.value(hdrs, "accept-charset"));
        _header.addHeader("HTTP_COOKIE", OracleWebAccess.value(hdrs, "cookie"));
        _header.addHeader("HTTP_IF_MODIFIED_SINCE", OracleWebAccess.value(hdrs, "if-modified-since"));
        _header.addHeader("HTTP_IF_NONE_MATCH", OracleWebAccess.value(hdrs, "if-none-match"));
        if (Requests.isStandardPort(request)) {
            _header.addHeader("HTTP_HOST", uri.getHost());
        } else {
            _header.addHeader("HTTP_HOST", uri.getHost() + ":" + uri.getPort());
        }
        _header.addHeader("HTTP_ORACLE_ECID", "");
        _header.addHeader("HTTP_PORT", this.normalizePort(uri) + "");
        _header.addHeader("HTTP_REFERER", OracleWebAccess.value(hdrs, "referer"));
        _header.addHeader("HTTP_USER_AGENT", OracleWebAccess.value(hdrs, "user-agent"));
        _header.addHeader("PATH_ALIAS", " ");
        _header.addHeader("PATH_INFO", path.substring(path.lastIndexOf("/")));
        _header.addHeader("PLSQL_GATEWAY", "WebDb");
        _header.addHeader("QUERY_STRING", uri.getQuery());
        _header.addHeader("REMOTE_ADDR", OracleWebAccess.value(hdrs, "X-APEX-REMOTE-ADDRESS"));
        String remoteUser = OracleWebAccess.remoteUser(request);
        _header.addHeader("REMOTE_USER", remoteUser);
        _header.addHeader("REQUEST_CHARSET", "AL32UTF8");
        _header.addHeader("REQUEST_IANA_CHARSET", Text.defaultEncoding());
        _header.addHeader("REQUEST_METHOD", request.method());
        _header.addHeader("REQUEST_PROTOCOL", uri.getScheme());
        _header.addHeader("REQUEST_SCHEME", uri.getScheme());
        _header.addHeader("SCRIPT_NAME", path.substring(0, path.lastIndexOf("/")));
        _header.addHeader("SCRIPT_PREFIX", "");
        _header.addHeader("SERVER_NAME", uri.getHost());
        _header.addHeader("SERVER_PORT", this.normalizePort(uri) + "");
        _header.addHeader("SERVER_PROTOCOL", "1.1");
        _header.addHeader("SERVER_SOFTWARE", "Resource-Templates");
        _header.addHeader("WEB_AUTHENT_PREFIX", " ");
        return _header;
    }

    private int normalizePort(URI uri) {
        int serverPort = uri.getPort();
        if (-1 == serverPort) {
            if ("https".equals(uri.getScheme())) {
                return 443;
            }
            return 80;
        }
        return serverPort;
    }

    private InputStream getStream(Map<String, Object> results) {
        Reader charStream = (Reader)results.get("lob");
        if (charStream == null) {
            return null;
        }
        return ReaderStream.stream((Reader)charStream, (Charset)Text.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Transaction txn, OWA.Headers hdrs) throws SQLException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("num_headers", hdrs.getSize());
        parameters.put("header_names", hdrs.getNames());
        parameters.put("header_values", hdrs.getValues());
        JDBCCall init = null;
        try {
            init = this.jdbc.call(txn, OWAStatement.INIT.stmt());
            init.bind(parameters);
            init.execute();
        }
        catch (Throwable throwable) {
            Closeables.close(init);
            throw throwable;
        }
        Closeables.close((Object)init);
    }

    protected static String remoteUser(RequestEntity request) {
        String remoteUser = Requests.remoteUser(request);
        String jdbcProxyUser = JDBCProxyPrincipal.jdbcProxyUser((CompoundPrincipal)request.principal());
        String jdbcUser = OracleWebAccess.jdbcUserName(request.principal());
        if (remoteUser == null) {
            remoteUser = jdbcProxyUser == null ? jdbcUser : jdbcProxyUser;
        }
        return remoteUser;
    }

    static InputStream download(JDBCCallProvider jdbc, Transaction txn, String docInfo) throws SQLException, IOException {
        if (docInfo.equals("B")) {
            return OracleWebAccess.download(jdbc, txn, OWAStatement.DOWNLOAD_BLOB.stmt());
        }
        if (docInfo.equals("F")) {
            return OracleWebAccess.download(jdbc, txn, OWAStatement.DOWNLOAD_BFILE.stmt());
        }
        throw new IllegalArgumentException("docInfo type not understood" + docInfo);
    }

    private static EntityHeaders consumeHeaders(InputStream content) {
        return Entities.headers(OracleWebAccess.headers(content));
    }

    private static InputStream download(JDBCCallProvider jdbc, Transaction txn, Statement stmt) throws SQLException {
        JDBCCall download = jdbc.call(txn, stmt);
        download.bind(Collections.emptyMap());
        BindableCallResults results = download.execute();
        InputStream content = (InputStream)results.get("content");
        return Closeables.alsoClose((InputStream)content, (Object[])new Object[]{download});
    }

    private static Iterator<EntityHeader> headers(final InputStream content) {
        if (null == content) {
            throw new NullPointerException();
        }
        return new AbstractIterator<EntityHeader>(){
            private boolean finished = false;

            protected EntityHeader advance() {
                EntityHeader header = null;
                if (!this.finished) {
                    while (header == null) {
                        EntityHeader hdr;
                        String line = this.nextLine();
                        if (line.isEmpty()) {
                            this.finished = true;
                            return null;
                        }
                        int delimiter = line.indexOf(58);
                        if (delimiter == -1) continue;
                        String name = line.substring(0, delimiter).trim();
                        String value = line.substring(delimiter + 1).trim();
                        if ("Status".equalsIgnoreCase(name)) {
                            name = "X-APEX-STATUS-CODE";
                            value = Integer.toString(HttpStatusCode.statusCode(value).statusCode());
                        }
                        if (OracleWebAccess.ignored(hdr = Entities.header(name, value))) continue;
                        header = hdr;
                    }
                }
                return header;
            }

            private String nextLine() {
                try {
                    StringBuilder line = new StringBuilder();
                    boolean eol = false;
                    int data = content.read();
                    while (!eol) {
                        if (-1 == data || 10 == data) {
                            eol = true;
                            continue;
                        }
                        line.append((char)data);
                        data = content.read();
                    }
                    return line.toString().trim();
                }
                catch (IOException e) {
                    throw WebException.internalError(e, new Reason[0]);
                }
            }
        };
    }

    private static boolean ignored(EntityHeader header) {
        return header.matches(HttpHeader.CONTENT_LENGTH) || header.matches("X-ORACLE-IGNORE");
    }

    private static String jdbcUserName(CompoundPrincipal principal) {
        JDBCPrincipal jdbc = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (jdbc == null) {
            return null;
        }
        return jdbc.getName();
    }

    private static String value(EntityHeaders hdrs, String name) {
        EntityHeader hdr = hdrs.header(name);
        if (hdr != null) {
            return hdr.value();
        }
        return null;
    }
}

