/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.plsql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.jdbc.BindableCallResults;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.FormFields;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.json.JSONPayload;
import oracle.dbtools.rt.plsql.OracleWebAccess;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.SQLResource;
import oracle.dbtools.rt.web.AcceptFormatting;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.VirusScanner;
import oracle.dbtools.rt.web.fileupload.FileUploadEntity;
import org.apache.commons.fileupload.FileItemStream;

@Service(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="plsql/block"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorLabel", value="PL/SQL Block"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorDescription", value="Handle a request using the supplied PL/SQL anonymous block"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorExample", value="begin insert into media values(:path,:contentType,:body); end;")})
public class AnonymousBlockGenerator
implements ResourceGenerator {
    @Reference
    private JDBCCallProvider jdbc;
    private OracleWebAccess owa;
    @Reference
    private VirusScanner scanner;
    public static final String ANONYMOUS_BLOCK_TYPE = "plsql/block";
    static final String BODY = "body";
    static final String CONTENT_TYPE = "content_type";
    private static final String OLD_CONTENT_TYPE = "contentType";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Entity generate(ResourceRequest request) throws IOException {
        Entity entity;
        JDBCCall call = null;
        JDBCTransaction txn = null;
        Entity response = null;
        try {
            SQLResource resource = SQLResource.call(request);
            boolean isForm = Requests.isHtmlForm(request.request());
            boolean isMultipart = FileUploadEntity.isMultipartContent(request.request());
            boolean isJson = JSONPayload.isJson(request.request());
            boolean isBodyUsed = resource.statement().usesParameters(new String[]{BODY});
            String contentType = null;
            InputStream body = null;
            List<Pair<String, Object>> formFields = null;
            resource.parameter(CONTENT_TYPE, String.class, ParameterAccess.IN);
            resource.parameter(OLD_CONTENT_TYPE, String.class, ParameterAccess.IN);
            if (isForm && !isBodyUsed) {
                FormFields fields = Requests.formFields(request.request());
                formFields = new ArrayList<Pair<String, Object>>();
                for (String name : fields) {
                    for (String value : fields.values((Object)name)) {
                        formFields.add((Pair<String, Object>)Pair.pair((Object)name, (Object)value));
                    }
                }
                for (Pair<String, Object> formField : formFields) {
                    resource.parameter((String)formField.first(), formField.second().getClass(), ParameterAccess.IN);
                }
            } else if (isJson && !isBodyUsed) {
                formFields = JSONPayload.toFields(request.request());
            } else {
                if (!isMultipart) {
                    ContentType requestContentType = request.request().contentType();
                    if (requestContentType != null) {
                        contentType = requestContentType.toString();
                    }
                    body = request.request().body();
                } else {
                    formFields = new ArrayList<Pair<String, Object>>();
                    FileUploadEntity uploads = FileUploadEntity.fileUpload(request.request());
                    for (FileItemStream upload : uploads) {
                        if (upload.isFormField()) {
                            String value;
                            String name = upload.getFieldName();
                            value = null;
                            InputStream text = null;
                            try {
                                text = upload.openStream();
                                value = StreamCopy.string((InputStream)text);
                            }
                            finally {
                                Closeables.close((Object)text);
                            }
                            if (value == null) continue;
                            formFields.add((Pair<String, Object>)Pair.pair((Object)name, (Object)value));
                            continue;
                        }
                        contentType = upload.getContentType();
                        body = upload.openStream();
                        break;
                    }
                }
                if (isBodyUsed) {
                    resource.parameter(BODY, InputStream.class, ParameterAccess.IN);
                }
            }
            Map<String, ?> params = resource.inboundValues();
            params.put(CONTENT_TYPE, contentType);
            params.put(OLD_CONTENT_TYPE, contentType);
            if (formFields != null) {
                for (Pair<String, Object> formField : formFields) {
                    params.put((String)formField.first(), formField.second());
                }
            }
            if (isBodyUsed) {
                body = this.scan(body);
                params.put(BODY, body);
            }
            txn = this.jdbc.transaction((Principal)request.request().principal());
            this.owa.init((Transaction)txn, request.request());
            call = this.jdbc.call((Transaction)txn, resource.statement());
            call.bind(params);
            BindableCallResults outboundValues = call.execute();
            Pair<EntityHeaders, Map<String, Object>> responseValues = resource.outboundValues((Map<String, Object>)outboundValues);
            Map responseParameters = (Map)responseValues.second();
            EntityHeaders responseHeaders = (EntityHeaders)responseValues.first();
            if (responseParameters.isEmpty()) {
                response = Entities.merge(this.owa.response((Transaction)txn), responseHeaders);
            } else {
                EntityHeader forward;
                responseHeaders = Entities.merge(responseHeaders, Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}));
                if ((isForm || isMultipart) && (forward = responseHeaders.header("X-APEX-FORWARD")) != null) {
                    responseHeaders = Entities.merge(responseHeaders, Entities.headers("X-APEX-STATUS-CODE", Integer.toString(HttpStatusCode.FOUND.statusCode())));
                }
                AcceptFormatting contentFormatting = AcceptFormatting.contentFormatting(request.request());
                JSONOptions options = JSONOptions.configure(contentFormatting.parameters());
                InputStream json = this.toJson(options, responseParameters);
                response = Entities.entity(json, responseHeaders);
            }
            entity = Entities.alsoClose(response, txn);
        }
        catch (SQLException e) {
            try {
                AnonymousBlockGenerator.rollback(txn);
                throw JDBCException.wrap((SQLException)e);
                catch (RuntimeException e2) {
                    AnonymousBlockGenerator.rollback(txn);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                Closeables.close(call);
                throw throwable;
            }
        }
        Closeables.close((Object)call);
        return entity;
    }

    protected void activate(ServiceProperties props) throws Exception {
        this.owa = new OracleWebAccess(this.jdbc);
    }

    private InputStream scan(InputStream content) {
        return this.scanner.scan(content);
    }

    private InputStream toJson(JSONOptions options, Map<String, Object> results) {
        if (results.isEmpty()) {
            return StreamCopy.emptyStream();
        }
        JSONBuilder b = JSONBuilder.o((JSONOptions)options);
        for (String name : results.keySet()) {
            Object value = results.get(name);
            b.p(name, value);
        }
        return new ByteArrayInputStream(JSONBuilder.toByteArray((JSONOptions)b.options(), (JSONNode)b.build()));
    }

    private static void rollback(Transaction txn) {
        if (txn != null) {
            txn.rollbackOnly();
            Closeables.close((Object)txn);
        }
    }
}

