/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.paging;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.rt.paging.AutoPaginatedResource;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.web.Requests;

public abstract class Pagination {
    private Pagination() {
    }

    public static ResourceRequest autoPaginate(ResourceRequest request) {
        if (Pagination.needsPagination(request)) {
            return new AutoPaginatedResource(request);
        }
        return request;
    }

    private static boolean needsPagination(ResourceRequest request) {
        return Requests.isRead(request.request()) && request.itemsPerPage() > 0 && !Pagination.hasExplicitPagination(request);
    }

    private static boolean hasExplicitPagination(ResourceRequest request) {
        Statement stmt = StatementBuilder.query((String)request.content(), (String[])new String[0]);
        return Pagination.containsParameter(stmt, "row_offset", "row_count", "page_offset", "page_size");
    }

    private static boolean containsParameter(Statement stmt, String ... parameters) {
        for (String parameter : parameters) {
            try {
                stmt.parameter(parameter);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    public static ResultRow hyperlinks(String path, long pageOffset, Iterator<ResultRow> rows) {
        if (pageOffset == -1L || rows == null) {
            return null;
        }
        boolean hasRows = rows.hasNext();
        Pair<QueryString, Long> page = Pagination.paginate(path);
        if (page == null) {
            return null;
        }
        QueryString target = (QueryString)page.first();
        if (!hasRows && pageOffset == 0L) {
            return null;
        }
        ArrayList<ResultRows.ResultColumn> columns = new ArrayList<ResultRows.ResultColumn>();
        if (pageOffset > 0L) {
            String previous = target.toString();
            columns.add(ResultRows.column((String)"$first", (Object)previous));
            if (pageOffset > 1L) {
                previous = target.replace(Pagination.pageParameter(), Long.toString(pageOffset - 1L)).toString();
            }
            columns.add(ResultRows.column((String)"$previous", (Object)previous));
        }
        if (hasRows) {
            String next = target.replace(Pagination.pageParameter(), Long.toString(pageOffset + 1L)).toString();
            columns.add(ResultRows.column((String)"$next", (Object)next));
        }
        return ResultRows.row(columns);
    }

    static Pair<QueryString, Long> paginate(String path) {
        Long value;
        QueryString existing;
        QueryString withoutPage = existing = QueryString.parse((String)path);
        String page = (String)existing.get((Object)Pagination.pageParameter());
        long pageOffset = 0L;
        if (page != null && (value = Pagination.toLong(page)) != null) {
            withoutPage = existing.remove(Pagination.pageParameter(), page);
            pageOffset = value;
        }
        return Pair.pair((Object)withoutPage, (Object)pageOffset);
    }

    private static Long toLong(String page) {
        try {
            Long value = (Long)PrimitiveTypes.valueOf((CharSequence)page, Long.class);
            return value;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String pageParameter() {
        return "page";
    }

    public static long rowOffset(long pageOffset, long itemsPerPage) {
        return 1L + pageOffset * itemsPerPage;
    }

    public static long rowCount(long pageOffset, long itemsPerPage) {
        long rowOffset = Pagination.rowOffset(pageOffset, itemsPerPage);
        long rowCount = rowOffset + itemsPerPage - 1L;
        return rowCount;
    }
}

