/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.OAuthAuthorization;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.TemplateRequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;

@Service(provides={ResourceDispatcher.class})
public class ApprovalRequestHandler
extends TemplateRequestHandler {
    @Reference
    private OAuthProvider oauth;
    static final String PATH = "oauth2/auth";
    public static final RequestHandlerMetaData META_DATA = ApprovalRequestHandler.secureSession(LogonRealm.OAUTH_APPROVALS, "oauth2/auth?{query}", HttpMethod.GET);
    private static final TemplateResourceGenerator SCOPE_TEMPLATE = TemplateResourceGenerator.templateFromUrl((CharSequence)((Object)ContentTypes.HTML), "oauth2/scope.html", new String[0]);
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl((CharSequence)((Object)ContentTypes.HTML), "oauth2/approve.html", "scopes");

    public ApprovalRequestHandler() {
        super(META_DATA, TEMPLATE);
    }

    @Override
    protected Map<String, String> values(RequestEntity request) {
        LocalePreference localePreference = LocalePreference.preference(request);
        ApprovalRequest ar = this.oauth.pendingRequest(request);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("scopes", this.scopes(localePreference, ar.scopes()));
        values.put("base", request.base());
        values.put("clientName", ar.name());
        values.put("clientEmail", ar.email());
        values.put("clientRedirectURI", OAuthAuthorization.redirectUri(ar));
        values.put("approvalId", ar.id().toString());
        if (ar.pendingId() != null) {
            values.put("pendingId", ar.pendingId().toString());
        }
        values.put("csrfToken", this.session(request).csrfToken());
        return values;
    }

    private String scopes(LocalePreference localePreference, Set<ApprovalRequest.Scope> scopes) {
        StringBuilder text = new StringBuilder();
        for (ApprovalRequest.Scope scope : scopes) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("scopeTitle", scope.title());
            String description = scope.description();
            if (description == null) {
                description = "No description provided";
            }
            values.put("scopeDescription", description);
            text.append(SCOPE_TEMPLATE.encode(localePreference, values));
        }
        return text.toString();
    }
}

