/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ResourceDispatcher.class})
public class ApprovalHandler
extends RequestHandler {
    @Reference
    private OAuthProvider oauth;
    public static final String PATH = "oauth2/approval";
    private static final RequestHandlerMetaData META_DATA = ApprovalHandler.secureSession(LogonRealm.OAUTH_APPROVALS, "oauth2/approval", HttpMethod.POST);

    public ApprovalHandler() {
        super(META_DATA);
    }

    @Override
    protected Entity post(RequestEntity request) throws IOException {
        this.oauth.approveRequest(request);
        throw WebException.badRequest(Reason.reason("pending_id", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ApprovalHandler.0", "Bad pending approval id", new Object[0])));
    }
}

