/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.PrimitiveTypes;

public class AccessTokens {
    private final long accessDuration;
    private final String accessToken;
    private final long refreshDuration;
    private final String refreshToken;
    private final long startTime;
    private static final long AUTH_CODE_DIVISOR = 12L;
    private static final long DEFAULT_TOKEN_DURATION = 3600L;
    private static final long REFRESH_TOKEN_MULTIPLIER = 24L;

    private AccessTokens(String accessToken, String refreshToken, long startTime, long accessExpiry, long refreshExpiry) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.startTime = startTime;
        this.accessDuration = accessExpiry;
        this.refreshDuration = refreshExpiry;
    }

    public long accessDuration() {
        return this.accessDuration;
    }

    public long accessExpiry() {
        return this.startTime + this.accessDuration;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessTokens other = (AccessTokens)obj;
        if (this.accessDuration != other.accessDuration) {
            return false;
        }
        if (this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken)) {
            return false;
        }
        if (this.refreshDuration != other.refreshDuration) {
            return false;
        }
        return !(this.refreshToken == null ? other.refreshToken != null : !this.refreshToken.equals(other.refreshToken));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.accessDuration ^ this.accessDuration >>> 32);
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (int)(this.refreshDuration ^ this.refreshDuration >>> 32);
        result = 31 * result + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
        return result;
    }

    public long refreshExpiry() {
        return this.startTime + this.refreshDuration;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccessTokens [accessToken=");
        builder.append(this.accessToken);
        builder.append(", refreshToken=");
        builder.append(this.refreshToken);
        builder.append(", accessExpiry=");
        builder.append(this.accessDuration);
        builder.append(", refreshExpiry=");
        builder.append(this.refreshDuration);
        builder.append("]");
        return builder.toString();
    }

    boolean hasRefreshToken() {
        return this.refreshDuration > 0L;
    }

    boolean isAuthorizationCode() {
        return this.accessDuration == 0L && this.refreshDuration > 0L && this.refreshToken != null;
    }

    boolean isIndirectToken() {
        return this.accessDuration > 0L && this.refreshDuration == 0L;
    }

    long refreshDuration() {
        return this.refreshDuration;
    }

    public static AccessTokens accessAndRefreshTokens() {
        long now = System.currentTimeMillis();
        long accessDuration = AccessTokens._tokenDuration();
        long refreshDuration = AccessTokens._refreshDuration();
        String accessToken = Identifiers.randomIdentifier();
        String refreshToken = Identifiers.randomIdentifier();
        return new AccessTokens(accessToken, refreshToken, now, accessDuration, refreshDuration);
    }

    public static AccessTokens accessTokenOnly() {
        long now = System.currentTimeMillis();
        long accessDuration = AccessTokens._tokenDuration();
        String accessToken = Identifiers.randomIdentifier();
        long refreshDuration = 0L;
        String refreshToken = Identifiers.randomIdentifier();
        return new AccessTokens(accessToken, refreshToken, now, accessDuration, refreshDuration);
    }

    public static AccessTokens authorizationCode() {
        long now = System.currentTimeMillis();
        long accessDuration = 0L;
        long refreshDuration = AccessTokens._codeDuration();
        String accessToken = Identifiers.randomIdentifier();
        String refreshToken = Identifiers.randomIdentifier();
        return new AccessTokens(accessToken, refreshToken, now, accessDuration, refreshDuration);
    }

    private static long _codeDuration() {
        long duration = AccessTokens._tokenDuration();
        return duration /= 12L;
    }

    private static long _refreshDuration() {
        long duration = AccessTokens._tokenDuration();
        return duration *= 24L;
    }

    private static long _tokenDuration() {
        return (Long)PrimitiveTypes.valueOf((CharSequence)GlobalConfiguration.globalConfiguration().get("security.oauth.tokenLifetime", Long.toString(3600L)), Long.class) * 1000L;
    }
}

