/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityStatementBuilder;
import oracle.dbtools.rt.jdbc.entity.JDBCNestedEntityStatements;

class JDBCEntityStatementsImpl<T extends TenantEntity>
implements JDBCNestedEntityStatements {
    private final Statement children;
    private final Statement delete;
    private final Statement deleteChildren;
    private final Statement entities;
    private final Statement entityById;
    private final Statement insert;
    private final JDBCEntityMetaData<T> metadata;
    private final Statement update;

    public JDBCEntityStatementsImpl(JDBCEntityMetaData<T> metadata) {
        this.metadata = metadata;
        JDBCEntityMetaData.Table table = metadata.table();
        this.delete = JDBCEntityStatementBuilder.call().delete(table);
        this.insert = JDBCEntityStatementBuilder.call().insert(table);
        this.update = JDBCEntityStatementBuilder.call().update(table);
        this.entityById = JDBCEntityStatementBuilder.query().entity(table);
        this.entities = JDBCEntityStatementBuilder.query().entities(table);
        JDBCEntityMetaData<?> childEntity = metadata.childEntity();
        if (childEntity == null) {
            this.deleteChildren = null;
            this.children = null;
        } else {
            this.deleteChildren = this.deleteChildren(metadata);
            this.children = this.children(metadata);
        }
    }

    private Statement children(JDBCEntityMetaData<T> metadata) {
        JDBCEntityMetaData<?> childEntity = metadata.childEntity();
        JDBCEntityMetaData.Table childTable = childEntity.table();
        JDBCEntityMetaData.Column parentColumn = metadata.childEntityColumn();
        return JDBCEntityStatementBuilder.query().selectFrom(childTable).where(childTable, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(childTable, parentColumn.column()), JDBCEntityStatementBuilder.parameter("parent_id", parentColumn.type(), ParameterAccess.IN))).defaultOrdering(childTable).build();
    }

    private Statement deleteChildren(JDBCEntityMetaData<T> metadata) {
        JDBCEntityMetaData<?> childEntity = metadata.childEntity();
        JDBCEntityMetaData.Table childTable = childEntity.table();
        JDBCEntityMetaData.Column parentColumn = metadata.childEntityColumn();
        return JDBCEntityStatementBuilder.call().delete().from(childTable).where(childTable, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(childTable, parentColumn.column()), JDBCEntityStatementBuilder.parameter("parent_id", parentColumn.type(), ParameterAccess.IN))).build();
    }

    @Override
    public Statement children() {
        return this.children;
    }

    @Override
    public Statement delete() {
        return this.delete;
    }

    @Override
    public Statement deleteChildren() {
        return this.deleteChildren;
    }

    @Override
    public Statement entities() {
        return this.entities;
    }

    @Override
    public Statement entityById() {
        return this.entityById;
    }

    @Override
    public Statement insert() {
        return this.insert;
    }

    public JDBCEntityMetaData<T> metadata() {
        return this.metadata;
    }

    @Override
    public Statement update() {
        return this.update;
    }
}

