/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.tenants;

import java.math.BigInteger;
import oracle.dbtools.common.identifiers.NumericIdentifiers;
import oracle.dbtools.rt.home.tenants.MaybeInternalIdentifier;

public class TenantIdentifier
implements Comparable<TenantIdentifier>,
MaybeInternalIdentifier {
    private final BigInteger entityId;
    private final BigInteger tenantId;
    public static final TenantIdentifier NO_PARENT = null;
    private static final Number INTERNAL = NumericIdentifiers.identifier((Number)10L);

    protected TenantIdentifier() {
        this(NumericIdentifiers.identifier((Number)-1), NumericIdentifiers.identifier((Number)0));
    }

    protected TenantIdentifier(TenantIdentifier id) {
        this(id.tenantId(), id.entityId());
    }

    public TenantIdentifier(Number tenantId, Number entityId) {
        if (tenantId == null || entityId == null) {
            throw new NullPointerException();
        }
        this.tenantId = TenantIdentifier.normalize(tenantId);
        this.entityId = TenantIdentifier.normalize(entityId);
    }

    private static BigInteger normalize(Number value) {
        return (BigInteger)NumericIdentifiers.NUMERIC_IDENTIFIER_TYPE.cast(NumericIdentifiers.identifier((Number)value));
    }

    private static Number valueOf(String text) {
        return NumericIdentifiers.valueOf((String)text);
    }

    @Override
    public int compareTo(TenantIdentifier o) {
        int result = this.tenantId.compareTo(o.tenantId);
        if (result == 0) {
            result = this.entityId.compareTo(o.entityId);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TenantIdentifier other = (TenantIdentifier)obj;
        return this.equals(other);
    }

    public boolean equals(TenantIdentifier other) {
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        return result;
    }

    @Override
    public boolean isInternal() {
        return INTERNAL.equals(this.tenantId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tenantId);
        builder.append("|");
        builder.append(this.entityId);
        return builder.toString();
    }

    protected Number entityId() {
        return this.entityId;
    }

    protected Number tenantId() {
        return this.tenantId;
    }

    protected static TenantIdentifier id(Number tenantId, Number entityId) {
        return new TenantIdentifier(tenantId, entityId);
    }

    public static TenantIdentifier parseId(String text) {
        String[] segments = text.split("\\|");
        Number tenantId = TenantIdentifier.valueOf(segments[0]);
        Number entityId = TenantIdentifier.valueOf(segments[1]);
        return TenantIdentifier.id(tenantId, entityId);
    }

    static TenantIdentifier id(TenantIdentifier id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return TenantIdentifier.id(id.tenantId, id.entityId);
    }
}

