/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import java.math.BigInteger;
import java.util.EventListener;
import oracle.dbtools.common.identifiers.NumericIdentifiers;

public class EntityMetaData {
    private long created = -1L;
    private String createdBy = "unknown";
    private transient UpdateListener listener;
    private long updated = -1L;
    private String updatedBy = "unknown";
    private BigInteger version = (BigInteger)NumericIdentifiers.NUMERIC_IDENTIFIER_TYPE.cast(UNVERSIONED);
    public static final String UNKNOWN = "unknown";
    public static final Number UNVERSIONED = NumericIdentifiers.identifier((Number)-1);

    public long created() {
        return this.created;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public EntityMetaData createdBy(String createdBy, long when) {
        return this.updatedBy(UpdateType.CREATED, createdBy, when);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityMetaData other = (EntityMetaData)obj;
        if (this.created != other.created) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.updated != other.updated) {
            return false;
        }
        if (this.updatedBy == null ? other.updatedBy != null : !this.updatedBy.equals(other.updatedBy)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (int)(this.updated ^ this.updated >>> 32);
        result = 31 * result + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public String toString() {
        return "EntityMetaData [created=" + this.created + ", createdBy=" + this.createdBy + ", updated=" + this.updated + ", updatedBy=" + this.updatedBy + ", version=" + this.version + "]";
    }

    public long updated() {
        return this.updated;
    }

    public String updatedBy() {
        return this.updatedBy;
    }

    public EntityMetaData updatedBy(String updatedBy, long when) {
        return this.updatedBy(UpdateType.UPDATED, updatedBy, when);
    }

    private EntityMetaData updatedBy(UpdateType type, String updatedBy, long when) {
        if (type == UpdateType.CREATED) {
            this.created = when;
            this.createdBy = updatedBy;
        }
        this.updatedBy = updatedBy;
        this.updated = when;
        if (this.listener != null) {
            this.listener.updated(type, updatedBy, this.updated());
        }
        return this;
    }

    public final void updateListener(UpdateListener listener) {
        this.listener = listener;
    }

    public Number version() {
        return this.version;
    }

    public EntityMetaData version(Number version) {
        this.version = (BigInteger)NumericIdentifiers.NUMERIC_IDENTIFIER_TYPE.cast(NumericIdentifiers.identifier((Number)version));
        return this;
    }

    public static enum UpdateType {
        CREATED,
        UPDATED;

    }

    public static interface UpdateListener
    extends EventListener {
        public void updated(UpdateType var1, String var2, long var3);
    }
}

