/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.filtering;

import java.util.LinkedHashSet;
import java.util.Map;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.query.filtering.impl.ClauseBuilderProvider;
import oracle.dbtools.query.filtering.impl.FilterSyntaxException;
import oracle.dbtools.query.filtering.impl.FilteredSQLQuery;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.ResourceRequestFilterBase;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class FilteredRequest
extends ResourceRequestFilterBase {
    private final String jsonFilter;
    private final FilteredSQLQuery filteredQuery;

    public FilteredRequest(ResourceRequest target) {
        super(target);
        this.jsonFilter = target.request().headers().header("X-APEX-QUERY_FILTER").value();
        String query = target.content();
        try {
            this.filteredQuery = ClauseBuilderProvider.INSTANCE.filterQuery(query, this.jsonFilter);
        }
        catch (FilterSyntaxException e) {
            throw WebException.badRequest(new Reason[0]);
        }
    }

    @Override
    public Iterable<ResourceParameter> explicitParameters() {
        Iterable parameters = this.filteredQuery.parameters();
        LinkedHashSet<ResourceParameter> params = new LinkedHashSet<ResourceParameter>();
        for (String param : parameters) {
            Class type = String.class;
            Object value = this.filteredQuery.values().get(param);
            if (value != null) {
                type = value.getClass();
            }
            params.add(new ResourceParameter(ResourceParameter.Kind.HEADER, param, param, type, ParameterAccess.IN));
        }
        return Iterables.merge(this.target.explicitParameters(), params);
    }

    @Override
    public Map<String, Object> inboundValues() {
        return Maps.merge(this.target.inboundValues(), (Map)this.filteredQuery.values());
    }

    @Override
    public String content() {
        return this.filteredQuery.query();
    }
}

