/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.entity;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;

class EntityHeadersImpl
implements EntityHeaders {
    private final Map<String, EntityHeader> headers = new LinkedHashMap<String, EntityHeader>();
    private static final HeaderToName HEADER_TO_NAME = new HeaderToName();

    EntityHeadersImpl(EntityHeader ... headers) {
        for (EntityHeader h : headers) {
            this.headers.put(h.name().toLowerCase(), h);
        }
    }

    EntityHeadersImpl(Iterator<EntityHeader> headers) {
        while (headers.hasNext()) {
            EntityHeader h = headers.next();
            this.headers.put(h.name().toLowerCase(), h);
        }
    }

    @Override
    public int compareTo(EntityHeaders o) {
        return Iterables.compare((Iterable)Iterables.transform((Iterable)this, (Transform)new NameToHeader(this)), (Iterable)Iterables.transform((Iterable)o, (Transform)new NameToHeader(o)));
    }

    @Override
    public EntityHeader header(CharSequence name) {
        EntityHeader h = this.headers.get(name.toString().toLowerCase());
        return h;
    }

    @Override
    public Iterator<String> iterator() {
        return Iterators.transform(this.headers.values().iterator(), (Transform)HEADER_TO_NAME);
    }

    public String toString() {
        return Entities.toString(this);
    }

    private static final class NameToHeader
    implements Transform<String, EntityHeader> {
        private final EntityHeaders headers;

        private NameToHeader(EntityHeaders headers) {
            this.headers = headers;
        }

        public EntityHeader apply(String name) {
            return this.headers.header(name);
        }
    }

    private static final class HeaderToName
    implements Transform<EntityHeader, String> {
        private HeaderToName() {
        }

        public String apply(EntityHeader header) {
            return header.name();
        }
    }
}

