/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.cors;

import java.io.IOException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.web.ApexHeaders;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Service(provides={CrossOriginResourceSharing.class, ResourceDispatcher.class}, priority=2)
public class CrossOriginResourceSharing
implements ResourceDispatcher {
    private static final Iterable<String> DO_NOT_EXPOSE_HEADERS = Iterables.merge((Iterable)Iterables.iterable((Object[])new String[]{HttpHeader.SET_COOKIE.text()}), (Iterable)Iterables.iterable((Object[])ApexHeaders.ALL));
    private static final Selector<String> IS_EXPOSABLE = new Selector<String>(){

        public Boolean apply(String header) {
            boolean exposable = !Iterables.contains((Iterable)DO_NOT_EXPOSE_HEADERS, (Selector)Selectors.equalsIgnoreCase((String)header));
            return exposable;
        }
    };

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        ResourceDispatcher.Score score = ResourceDispatcher.NO_MATCH;
        ResourceDispatcher.Score corsScore = this.choose(request);
        if (!ResourceDispatcher.NO_MATCH.equals(corsScore)) {
            return new ResourceDispatcher.Score(corsScore.type(), corsScore.score() + 10, SecurityConfigs.NONE, (Object)corsScore, corsScore.originsAllowed(), true);
        }
        return score;
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        ResourceDispatcher.Score corsScore = null;
        corsScore = score == null ? this.choose(request) : (ResourceDispatcher.Score)score.handle();
        Entity response = this.preFlightRequest(request, corsScore);
        return HttpResources.noVersion(response);
    }

    public Entity simpleRequest(RequestEntity request, Entity response, ResourceDispatcher.Score score) {
        String requestOrigin;
        boolean isPreflight = this.isPreflightRequest(request);
        if (!isPreflight && score.isCorsEnabled() && CrossOriginResourceSharing.hasRequestOrigin(request) && this.isValidRequestOrigin(requestOrigin = CrossOriginResourceSharing.requestOrigin(request), score)) {
            EntityHeadersBuilder builder = Entities.headers();
            CrossOriginResourceSharing.allowRequest(builder, requestOrigin);
            CrossOriginResourceSharing.exposeResponseHeaders(builder, response.headers());
            Entity corsResponse = Entities.merge(response, builder.build());
            return corsResponse;
        }
        return response;
    }

    private static void allowRequest(EntityHeadersBuilder builder, String requestOrigin) {
        builder.header((CharSequence)"Access-Control-Allow-Origin", requestOrigin);
        builder.header((CharSequence)"Access-Control-Allow-Credentials", "true");
    }

    private boolean allowed(String requestOrigin, Iterable<String> originsAllowed) {
        return Iterables.contains(originsAllowed, (Selector)Selectors.eq((Object)requestOrigin));
    }

    private ResourceDispatcher.Score choose(RequestEntity request) {
        boolean isCORSRequest = CrossOriginResourceSharing.hasRequestOrigin(request);
        if (isCORSRequest) {
            try {
                String corsMethod = this.corsRequestMethod(request);
                if (corsMethod != null) {
                    EntityHeaders hdrs = Entities.headers("X-APEX-METHOD", corsMethod);
                    RequestEntity corsRequest = Requests.merge(request, Entities.entity(null, hdrs));
                    ResourceDispatcher.Score corsScore = this.dispatchers().canDispatch(corsRequest);
                    String requestOrigin = CrossOriginResourceSharing.requestOrigin(request);
                    if (this.isValidRequestOrigin(requestOrigin, corsScore)) {
                        return corsScore;
                    }
                }
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
        return ResourceDispatcher.NO_MATCH;
    }

    private String corsRequestMethod(RequestEntity request) {
        EntityHeader header;
        if (HttpMethod.OPTIONS.equals(request.method()) && (header = request.headers().header("Access-Control-Request-Method")) != null) {
            return header.value();
        }
        return null;
    }

    private RequestDispatchers dispatchers() {
        return (RequestDispatchers)ServiceLocator.acquire(RequestDispatchers.class);
    }

    public static void corsEnableErrorResponseHeaders(String corsOrigin, EntityHeadersBuilder responseHeaders) {
        if (corsOrigin != null) {
            CrossOriginResourceSharing.allowRequest(responseHeaders, corsOrigin);
            CrossOriginResourceSharing.exposeResponseHeaders(responseHeaders, responseHeaders.build());
        }
    }

    private static void exposeResponseHeaders(EntityHeadersBuilder builder, EntityHeaders responseHeaders) {
        Iterable exposableHeaders = Iterables.select((Iterable)responseHeaders, IS_EXPOSABLE);
        builder.header((CharSequence)"Access-Control-Expose-Headers", exposableHeaders);
    }

    public static boolean hasRequestOrigin(RequestEntity request) {
        return null != CrossOriginResourceSharing.requestOrigin(request);
    }

    private boolean isPreflightRequest(RequestEntity request) {
        return null != this.corsRequestMethod(request);
    }

    private boolean isValidRequestOrigin(String requestOrigin, ResourceDispatcher.Score score) {
        if (score != null && !ResourceDispatcher.NO_MATCH.equals(score) && score.isCorsEnabled()) {
            if (RequestDispatchers.isPublicResource(score)) {
                return true;
            }
            Iterable<String> originsAllowed = score.originsAllowed();
            return this.allowed(requestOrigin, originsAllowed);
        }
        return false;
    }

    private Entity preFlightRequest(RequestEntity request, ResourceDispatcher.Score corsScore) {
        EntityHeader corsRequestHeaders = request.headers().header("Access-Control-Request-Headers");
        EntityHeadersBuilder preFlightHeaders = Entities.headers();
        if (corsRequestHeaders != null) {
            preFlightHeaders.header((CharSequence)"Access-Control-Allow-Headers", corsRequestHeaders.values());
        }
        String requestOrigin = CrossOriginResourceSharing.requestOrigin(request);
        CrossOriginResourceSharing.allowRequest(preFlightHeaders, requestOrigin);
        String corsMethod = this.corsRequestMethod(request);
        preFlightHeaders.header((CharSequence)"Access-Control-Allow-Methods", corsMethod);
        return Entities.entity(null, preFlightHeaders.build());
    }

    public static String requestOrigin(RequestEntity request) {
        EntityHeader origin;
        if (request != null && (origin = request.headers().header("Origin")) != null) {
            return origin.value();
        }
        return null;
    }
}

