/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.install.VersionFormat;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;
import oracle.jdbc.OracleConnection;

public class CdbPdbSetup {
    private static final int CON_ID_NDX = 0;
    private static final int CON_MODE_NDX = 1;
    private static final int CON_RESTRICTED_NDX = 2;
    private static final int CON_ORDS_VERSION_NDX = 3;
    private static final int CON_ORDS_INSTALL_TYPE_NDX = 4;
    private static final int CON_ERROR_MSG_NDX = 5;
    private static final int CON_DB_TYPE_NDX = 6;
    private static final int CON_PROCESS_TYPE_NDX = 7;
    private static final int CON_TOTAL_SIZE = 8;
    private static final int MAX_TRIES = 10;
    private static final int PROCESS_NDX = 0;
    private static final int VERSION_NDX = 1;
    private static final String CDB_ROOT = "CDB$ROOT";
    private static final String PDB_SEED = "PDB$SEED";
    private static final String CDB = "CDB";
    private static final String PDB = "PDB";
    private static final String NON_CDB = "NON_CDB";
    private static final String MIGRATE = "MIGRATE";
    private static final String READ_ONLY = "READ ONLY";
    private static final String READ_WRITE = "READ WRITE";
    private static final String MOUNTED = "MOUNTED";
    private static final String COMMON_USERS_ONLY = "COMMON_USERS_ONLY";
    private static final String COMMON_USERS_ORDS_INSTALLED = "COMMON_USERS_ORDS_INSTALLED";
    private static final String COMMON_ALL_ORDS_INSTALLED = "COMMON_ALL_ORDS_INSTALLED";
    private static final String ORDS_INSTALLED = "ORDS_INSTALLED";
    private static final String ORDS_NOT_INSTALLED = "NONE";
    private static final String SYSAUX_TBS = "SYSAUX";
    private static final String TEMP_TBS = "TEMP";
    private static final String USERS_TBS = "USERS";
    private static final String NULL_STR = "null";
    private static final String YES = "YES";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String ALTER_SET_CONTAINER_SQL = "alter session set container = ";
    private static final String ALL_CONTAINERS_INFO_SQL = "select con_id, name, open_mode, restricted from v$containers order by con_id";
    private static final String CON_DEF_TBS_NOT_EXIST_SQL = "select c.name from v$containers c where c.name not in (select x.name from v$containers x, v$tablespace y where y.name = upper(?) and x.con_id = y.con_id)";
    private static final String CON_TEMP_TBS_EXIST_SQL = "select c.name from v$containers c where c.name in  (select unique(z.name) from v$tempfile x, v$tablespace y, v$containers z   where y.name=upper(?) and z.con_id=x.con_id and x.ts#=y.ts# and x.con_id=y.con_id)";
    private static final String CON_TEMP_TBS_NOT_EXIST_SQL = "select c.name from v$containers c where c.name not in  (select unique(z.name) from v$tempfile x, v$tablespace y, v$containers z   where y.name=upper(?) and z.con_id=x.con_id and x.ts#=y.ts# and x.con_id=y.con_id)";
    private static final String DEF_TBS_SQL = "select tablespace_name from dba_tablespaces where tablespace_name = upper(?)";
    private static final String TEMP_TBS_SQL = "select distinct(tablespace_name) from dba_temp_files where tablespace_name = upper(?)";
    private static final String ROOT_TBS_SQL = "select username, default_tablespace, temporary_tablespace from dba_users where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')";
    private static final String GET_ORDS_VERSION_SQL = "declare \n   l_version varchar2(30) := 'UNKNOWN';  \n   l_ords_schema varchar2(30) := null; \n   l_public_user varchar2(30) := null; \n   l_common_pub_user varchar2(30) := 'NO'; \n   l_common_ords_schema varchar2(30) := 'NO'; \n   l_is_root varchar2(30) := 'NO'; \n   l_err number := 0; \n   l_total_users number := 0; \n   l_version_view_exists number := 0; \n   l_version_origin_con_id number := 0; \nbegin \n   $IF SYS.DBMS_DB_VERSION.VERSION >= 12 $THEN \n      if (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then \n         l_is_root := 'YES'; \n      end if; \n      -- Check if the ords schema and ords public user are common users \n      for c1 in (select username, common from all_users \n                 where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')) \n      loop \n        if (c1.username = 'ORDS_METADATA') then \n          l_common_ords_schema := c1.common; \n          l_ords_schema := 'ORDS_METADATA'; \n        elsif (c1.username = 'ORDS_PUBLIC_USER') then \n          l_common_pub_user := c1.common; \n          l_public_user := 'ORDS_PUBLIC_USER'; \n        end if; \n        l_total_users := l_total_users + 1; \n      end loop; \n   $ELSE \n      -- DB version 11g \n      -- check if ORDS_METADATA and ORDS_PUBLIC_USER exists; \n      select count(*) into l_total_users from all_users where username in ('ORDS_METADATA', 'ORDS_PUBLIC_USER'); \n   $END \n   if (l_total_users = 0) then \n      l_version := ''; \n   elsif (l_total_users=2) then \n      select count(*) into l_version_view_exists from all_views where owner='ORDS_METADATA' and view_name='ORDS_VERSION'; \n      if l_version_view_exists >= 1 then \n        if sys.dbms_db_version.VERSION >= 12 then \n          if l_version_view_exists = 1 then \n            execute immediate 'select origin_con_id from all_views where owner=''ORDS_METADATA'' and view_name=''ORDS_VERSION'' ' \n               into l_version_origin_con_id; \n          elsif l_version_view_exists > 1 then \n            begin \n              execute immediate 'select origin_con_id from all_views where owner=''ORDS_METADATA'' and view_name=''ORDS_VERSION'' ' \n                              || ' and origin_con_id = 1' \n                into l_version_origin_con_id; \n              exception \n                when others then \n                   null; \n            end; \n          end if; \n        end if; \n        execute immediate 'select version from ords_metadata.ords_version' into l_version; \n      else \n        if l_is_root = 'NO' then \n          l_err := 100; \n        end if; \n      end if; \n   elsif (l_total_users = 1) then \n      if (l_ords_schema is null and l_public_user is not null) then \n         l_err := 101; \n      elsif (l_public_user is null and l_ords_schema is not null) then \n         l_err := 102; \n      end if; \n   end if; \n   ? := l_version; \n   ? := l_err; \n   ? := l_total_users; \n   ? := l_version_view_exists; \n   ? := l_common_ords_schema; \n   ? := l_common_pub_user; \n   ? := l_version_origin_con_id; \n end; \n";
    private static final String GET_CDB_INFO = "declare\nl_cdb       VARCHAR2(10)  := 'NO'; \nl_is_root   VARCHAR2(10)  := 'false'; \nl_con_name  VARCHAR2(200) := ''; \nl_sess_user VARCHAR2(200) := ''; \nbegin \n    select cdb into l_cdb from v$database; \n    if (l_cdb = 'YES') and (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then \n      l_is_root := 'true'; \n    end if; \n    ? := l_cdb; \n    ? := l_is_root; \n    ? := sys_context('USERENV','CON_NAME'); \n    ? := sys_context('USERENV','SESSION_USER'); \nend; \n";
    private static final String IS_CDB_ROOT = "declare \nl_is_root VARCHAR2(10)  := 'false'; \nbegin \n  if (SYS.DBMS_DB_VERSION.VERSION >= 12) and (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then \n    :l_is_root := 'true'; \n  end if; \nend; \n";
    private static final Setting PROMPT_CDB_PDB_PROCESSING = Setting.setting("PROMPT_CDB_INSTALL", null, "1", false, "1", "2");
    private static final Setting PROMPT_TABLESPACE = Setting.setting("DB_TABLESPACE", null, "USERS");
    private static final Log LOG = Log.get(CdbPdbSetup.class);
    private Map<String, String[]> conModeMap;

    public static String getORDSVersion(Connection conn, Map<String, String> installParams) throws Exception {
        return new CdbPdbSetup().getProcessingType(conn, installParams);
    }

    public static void retrieveContainersToUninstall(Connection conn, Map<String, String> installParams) throws Exception {
        new CdbPdbSetup().retrieveUninstallContainers(conn, installParams);
    }

    public static void retrieveValidateParams(Connection conn, Map<String, String> installParams) throws Exception {
        new CdbPdbSetup().retrieveValidateContainers(conn, installParams);
    }

    public static void restartProcessingContainers(Connection conn, Map<String, String> installParams) throws Exception {
        new CdbPdbSetup().restartProcessContainers(conn, installParams);
    }

    public static String getInstallOrUpgrade(Connection conn, Map<String, String> installParams) throws Exception {
        return new CdbPdbSetup().getProcessingType(conn, installParams);
    }

    public static String getInstallOrUpgradeForPubUser(Connection conn, Map<String, String> installParams) throws Exception {
        return new CdbPdbSetup().getProcessingTypePubUser(conn, installParams);
    }

    private String getProcessingType(Connection conn, Map<String, String> installParams) throws Exception {
        Object[] conFlags;
        String processType = null;
        int dbVersion = CdbPdbSetup.getDBVersion(conn);
        boolean isCDB = false;
        boolean isRoot = false;
        if (dbVersion < 11) {
            LOG.info(SetupMessages.getString("ERR_INVALID_DB_RELEASE"));
            installParams.put("installer", "skip");
        }
        if (dbVersion >= 12 && !NullOrEmpty.nullOrEmpty((Object[])(conFlags = this.getContainerFlags(conn)))) {
            isCDB = (Boolean)conFlags[0];
            isRoot = (Boolean)conFlags[1];
        }
        processType = isCDB ? this.getCdbPdbProcessingType(conn, installParams, isRoot) : this.getNonCdbProcessingType(conn, installParams);
        return processType;
    }

    private String getCdbPdbProcessingType(Connection conn, Map<String, String> installParams, boolean isRoot) throws Exception {
        Map<String, String[]> containers = this.getContainersToProcess(conn, installParams, SetupMessages.getString("INSTALL_UPGRADE"));
        if (!NullOrEmpty.nullOrEmpty(containers)) {
            this.containersORDSVersion(conn, containers);
            String[] conValues = isRoot ? containers.get(CDB_ROOT) : containers.entrySet().iterator().next().getValue();
            String ordsStatus = conValues[4];
            String schemaVersion = conValues[3];
            String productVersion = installParams.get("product.version");
            if (this.isInstall(schemaVersion, ordsStatus)) {
                this.verifyInstall(conn, installParams, containers, isRoot);
            } else if (this.isUpgrade(schemaVersion, productVersion)) {
                this.verifyUpgrade(conn, installParams, containers, isRoot);
            } else {
                if (this.isInvalidProductVersion(schemaVersion, productVersion)) {
                    installParams.put("installer", "skip");
                    throw new Exception(SetupMessages.format("ERR_MISMATCH_VERSIONS", productVersion, schemaVersion));
                }
                if (isRoot) {
                    this.verifyUpgrade(conn, installParams, containers, isRoot);
                    if (NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer"))) {
                        installParams.put("installer", "none");
                        installParams.put("schema.version", schemaVersion);
                    }
                } else {
                    installParams.put("installer", "none");
                    installParams.put("schema.version", schemaVersion);
                }
            }
        } else {
            LOG.severe(SetupMessages.getString("ERR_CONTAINER_LIST_EMPTY"));
            installParams.put("installer", "skip");
        }
        return installParams.get("installer");
    }

    private String getNonCdbProcessingType(Connection conn, Map<String, String> installParams) throws Exception {
        Map<String, String[]> nonCDBInfo = this.getNonCdbInfo();
        this.containersORDSVersion(conn, nonCDBInfo);
        String[] conValues = nonCDBInfo.entrySet().iterator().next().getValue();
        String ordsStatus = conValues[4];
        String schemaVersion = conValues[3];
        String productVersion = installParams.get("product.version");
        if (this.isInstall(schemaVersion, ordsStatus)) {
            this.verifyInstall(conn, installParams, nonCDBInfo, false);
        } else if (this.isUpgrade(schemaVersion, productVersion)) {
            this.verifyUpgrade(conn, installParams, nonCDBInfo, false);
        } else {
            if (this.isInvalidProductVersion(schemaVersion, productVersion)) {
                installParams.put("installer", "skip");
                throw new Exception(SetupMessages.format("ERR_MISMATCH_VERSIONS", productVersion, schemaVersion));
            }
            installParams.put("installer", "none");
            installParams.put("schema.version", schemaVersion);
        }
        return installParams.get("installer");
    }

    private String getProcessingTypePubUser(Connection conn, Map<String, String> installParams) throws Exception {
        int dbVersion = CdbPdbSetup.getDBVersion(conn);
        if (dbVersion < 11) {
            LOG.info(SetupMessages.getString("ERR_INVALID_DB_RELEASE"));
            installParams.put("installer", "skip");
        }
        Map<String, String[]> pubUserInfo = this.getPublicUserInfo();
        this.containersORDSVersion(conn, pubUserInfo);
        String[] conValues = pubUserInfo.entrySet().iterator().next().getValue();
        String ordsStatus = conValues[4];
        String schemaVersion = conValues[3];
        String productVersion = installParams.get("product.version");
        if (this.isInstall(schemaVersion, ordsStatus)) {
            installParams.put("installer", "skip");
            throw new Exception(SetupMessages.getString("ERR_MD_EXISTS_VERSION_MISSING"));
        }
        if (this.isUpgrade(schemaVersion, productVersion)) {
            this.retrieveUpgradeInfo(installParams, dbVersion);
        } else {
            if (this.isInvalidProductVersion(schemaVersion, productVersion)) {
                installParams.put("installer", "skip");
                throw new Exception(SetupMessages.format("ERR_MISMATCH_VERSIONS", productVersion, schemaVersion));
            }
            if (!NullOrEmpty.nullOrEmpty((CharSequence)conValues[5])) {
                LOG.warning(conValues[5]);
                installParams.put("installer", "skip");
            } else {
                installParams.put("installer", "none");
                installParams.put("schema.version", schemaVersion);
            }
        }
        return installParams.get("installer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveUpgradeInfo(Map<String, String> installParams, int dbVersion) throws Exception {
        Object[] conFlags;
        Connection conn;
        boolean isRoot;
        boolean isCDB;
        block5: {
            isCDB = false;
            isRoot = false;
            conn = null;
            Console console = System.console();
            try {
                conn = SchemaSetup.verifyDBAUserConnection(console, installParams, installParams.get("db.url"), true);
                if (NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer")) || !installParams.get("installer").equals("skip")) break block5;
                LOG.fine("Could not get username/password.");
            }
            catch (Throwable throwable) {
                Closeables.close(conn);
                throw throwable;
            }
            Closeables.close((Object)conn);
            return;
        }
        if (dbVersion >= 12 && !NullOrEmpty.nullOrEmpty((Object[])(conFlags = this.getContainerFlags(conn)))) {
            isCDB = (Boolean)conFlags[0];
            isRoot = (Boolean)conFlags[1];
        }
        Map<String, String[]> containers = null;
        containers = isCDB ? this.getContainersToProcess(conn, installParams, SetupMessages.getString("UPGRADE")) : this.getNonCdbInfo();
        if (!NullOrEmpty.nullOrEmpty(containers)) {
            this.containersORDSVersion(conn, containers);
            this.verifyUpgrade(conn, installParams, containers, isRoot);
        }
        Closeables.close((Object)conn);
    }

    private void retrieveUninstallContainers(Connection conn, Map<String, String> installParams) throws Exception {
        Object[] conFlags;
        int dbVersion = CdbPdbSetup.getDBVersion(conn);
        if (dbVersion < 11) {
            LOG.info(SetupMessages.getString("ERR_INVALID_DB_RELEASE"));
            installParams.put("installer", "skip");
        }
        boolean isCDB = false;
        boolean isRoot = false;
        if (dbVersion >= 12 && !NullOrEmpty.nullOrEmpty((Object[])(conFlags = this.getContainerFlags(conn)))) {
            isCDB = (Boolean)conFlags[0];
            isRoot = (Boolean)conFlags[1];
        }
        Map<String, String[]> containers = null;
        containers = isCDB ? this.getContainersToProcess(conn, installParams, SetupMessages.getString("UNINSTALL")) : this.getNonCdbInfo();
        if (!NullOrEmpty.nullOrEmpty(containers)) {
            try {
                this.containersORDSVersion(conn, containers);
            }
            catch (SQLException e) {
                LOG.fine(e.getLocalizedMessage());
            }
            this.verifyUninstall(conn, installParams, containers, isRoot);
        }
    }

    private void retrieveValidateContainers(Connection conn, Map<String, String> installParams) throws Exception {
        Object[] conFlags;
        int dbVersion = CdbPdbSetup.getDBVersion(conn);
        if (dbVersion < 11) {
            LOG.info(SetupMessages.getString("ERR_INVALID_DB_RELEASE"));
            installParams.put("installer", "skip");
        }
        boolean isCDB = false;
        boolean isRoot = false;
        if (dbVersion >= 12 && !NullOrEmpty.nullOrEmpty((Object[])(conFlags = this.getContainerFlags(conn)))) {
            isCDB = (Boolean)conFlags[0];
            isRoot = (Boolean)conFlags[1];
        }
        Map<String, String[]> containers = null;
        containers = isCDB ? this.getContainersToProcess(conn, installParams, SetupMessages.getString("VALIDATE")) : this.getNonCdbInfo();
        if (!NullOrEmpty.nullOrEmpty(containers)) {
            this.containersORDSVersion(conn, containers);
            this.verifyValidate(conn, installParams, containers, isRoot);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restartProcessContainers(Connection conn, Map<String, String> installParams) throws Exception {
        String msgKey;
        String[] info;
        if (!installParams.containsKey("container.process.list")) {
            throw new Exception(SetupMessages.format("ERR_RESTART_MISSING_PROPERTY", "container.process.list"));
        }
        int dbVersion = CdbPdbSetup.getDBVersion(conn);
        if (dbVersion < 11) {
            LOG.info(SetupMessages.getString("ERR_INVALID_DB_RELEASE"));
            installParams.put("installer", "skip");
        }
        boolean isCDB = false;
        boolean isRoot = false;
        if (dbVersion < 12) throw new IOException(SetupMessages.getString("ERR_RESTART_NON_CDB"));
        Object[] conFlags = this.getContainerFlags(conn);
        if (!NullOrEmpty.nullOrEmpty((Object[])conFlags)) {
            isCDB = (Boolean)conFlags[0];
            isRoot = (Boolean)conFlags[1];
            if (!isCDB) throw new IOException(SetupMessages.getString("ERR_RESTART_NON_CDB"));
            if (!isRoot) {
                throw new IOException(SetupMessages.getString("ERR_RESTART_CONN_ROOT"));
            }
        }
        Map<String, String[]> containers = this.getContainersToProcess(conn, installParams, SetupMessages.getString("RESTART"));
        Map<String, String[]> processList = this.getContainersProcessInfoStr(installParams.get("container.process.list"));
        Map<String, String[]> completedList = this.getContainersProcessInfoStr(installParams.get("container.completed.list"));
        LinkedHashMap<String, String[]> verifyConList = new LinkedHashMap<String, String[]>();
        for (String conName : processList.keySet()) {
            String[] procValues = processList.get(conName);
            if (completedList.containsKey(conName)) {
                String[] compValues = completedList.get(conName);
                procValues[1] = compValues[1];
                if (procValues[0].equals("install")) {
                    procValues[0] = "upgrade";
                }
            }
            info = new String[8];
            if (containers.containsKey(conName)) {
                String[] conValues = containers.get(conName);
                info[0] = conValues[0];
                info[1] = conValues[1];
                info[2] = conValues[2];
                info[6] = conValues[6];
                info[7] = procValues[0];
                info[3] = procValues[1];
                verifyConList.put(conName, info);
            } else {
                msgKey = conName.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
                String msg = "";
                if (this.conModeMap.containsKey(conName)) {
                    info = this.conModeMap.get(conName);
                    msg = SetupMessages.format("CON_MODE_ERR", info[1], procValues[0], conName);
                } else {
                    msg = SetupMessages.format("CON_MISSING_ERR", procValues[0], conName);
                }
                info[5] = SetupMessages.format(msgKey, msg);
                info[7] = UNKNOWN;
            }
            verifyConList.put(conName, info);
        }
        for (String conName : containers.keySet()) {
            if (processList.containsKey(conName)) continue;
            String[] conValues = containers.get(conName);
            info = new String[8];
            info[0] = conValues[0];
            info[1] = conValues[1];
            info[2] = conValues[2];
            info[7] = UNKNOWN;
            msgKey = conName.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
            info[5] = SetupMessages.format(msgKey, SetupMessages.getString("CON_MISSING_IN_PROPERTY"));
            info[7] = UNKNOWN;
        }
        if (NullOrEmpty.nullOrEmpty(verifyConList)) return;
        this.verifyRestart(conn, installParams, verifyConList, isRoot);
    }

    private Map<String, String[]> getContainersProcessInfoStr(String containersStr) throws Exception {
        LinkedHashMap<String, String[]> containers = new LinkedHashMap<String, String[]>();
        if (!NullOrEmpty.nullOrEmpty((CharSequence)containersStr)) {
            String[] containerLst;
            String conSeparator = "\\^";
            String conDelimiter = "\\|";
            for (String container : containerLst = containersStr.split("\\|")) {
                String[] info = container.split("\\^");
                String name = info[0];
                String[] conInfo = new String[]{info[1], !info[2].equals(NULL_STR) ? info[2] : ""};
                containers.put(name, conInfo);
            }
        }
        LOG.fine("Total containers: " + containers.size());
        return containers;
    }

    private void verifyInstall(Connection conn, Map<String, String> installParams, Map<String, String[]> containers, boolean isRoot) throws Exception {
        boolean isCdbCommonUsersOption = false;
        if (isRoot && installParams.containsKey("cdb.install.common.users")) {
            isCdbCommonUsersOption = Boolean.valueOf(installParams.get("cdb.install.common.users"));
        }
        StringBuilder errMsg = new StringBuilder();
        StringBuilder installMsg = new StringBuilder();
        StringBuilder conInfo = new StringBuilder();
        String dbType = null;
        String dbName = null;
        for (String containerName : containers.keySet()) {
            String[] values = containers.get(containerName);
            String version = values[3];
            String mode = values[1];
            String restricted = values[2];
            String installStatus = values[4];
            String conErrorMsg = values[5];
            dbType = values[6];
            dbName = null;
            if (!NullOrEmpty.nullOrEmpty((CharSequence)conErrorMsg)) {
                errMsg.append(conErrorMsg).append("\n");
                continue;
            }
            if (this.isInstall(version, installStatus)) {
                if (conInfo.length() > 0) {
                    conInfo.append("|");
                }
                conInfo.append(this.formatContainerInfo(containerName, "install", version));
                if (isRoot) {
                    installMsg.append(this.getContainerInstallMsg(containerName, installParams.get("product.version"), isCdbCommonUsersOption)).append(" ").append(this.getContainerModeMsg(mode, restricted)).append("\n");
                    continue;
                }
                installMsg.append(containerName);
                dbName = containerName;
                continue;
            }
            if (!this.isOrdsInstalled(version, installStatus)) continue;
            errMsg.append(SetupMessages.format("CON_PDB_MSG", containerName, SetupMessages.format("CON_ORDS_EXISTS", version))).append("\n");
        }
        if (errMsg.length() > 0) {
            installParams.put("installer", "skip");
            LOG.console(SetupMessages.format("ERR_CDB_INSTALL_PDB_EXISTS", errMsg.toString()));
            return;
        }
        if (conInfo.length() > 0) {
            LOG.fine("conInfo :" + conInfo.toString());
            if (!isRoot && dbType.equals(PDB) && CdbPdbSetup.isOrdsInstalledRootContainer(conn, dbName)) {
                installParams.put("installer", "skip");
                LOG.info(SetupMessages.format("ERR_ROOT_CONTAINS_ORDS", installMsg.toString()));
                return;
            }
            boolean install = true;
            if (isRoot) {
                String msgKey = isCdbCommonUsersOption ? "CDB_INSTALL_COMMON_USERS" : "CDB_INSTALL_COMMON_OBJS";
                LOG.console(SetupMessages.format(msgKey, installMsg.toString()));
                install = this.requestToContinue(installParams, "install");
            }
            if (install) {
                this.containerTablespaces(conn, installParams, containers);
                installParams.put("containers.info", conInfo.toString());
                installParams.put("schema.version", "");
                if (isRoot) {
                    installParams.put("installer", "cdb.install");
                } else {
                    installParams.put("installer", "install");
                }
            } else {
                installParams.put("installer", "skip");
            }
        } else {
            installParams.put("installer", "skip");
        }
    }

    private void verifyUpgrade(Connection conn, Map<String, String> installParams, Map<String, String[]> containers, boolean isRoot) throws Exception {
        StringBuilder errMsg = new StringBuilder();
        StringBuilder upgradeMsg = new StringBuilder();
        StringBuilder conInfo = new StringBuilder();
        String productVersion = installParams.get("product.version");
        String schemaVersion = null;
        String installStatus = null;
        String dbType = null;
        int pdbInstallCount = 0;
        int upgradeCount = 0;
        for (String containerName : containers.keySet()) {
            String[] values = containers.get(containerName);
            String mode = values[1];
            String restricted = values[2];
            String conErrorMsg = values[5];
            String conKey = containerName.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
            schemaVersion = values[3];
            installStatus = values[4];
            dbType = values[6];
            if (!NullOrEmpty.nullOrEmpty((CharSequence)conErrorMsg)) {
                errMsg.append(conErrorMsg).append("\n");
                continue;
            }
            if (this.isInstall(schemaVersion, installStatus)) {
                if (!isRoot || !dbType.equals(PDB)) continue;
                if (conInfo.length() > 0) {
                    conInfo.append("|");
                }
                conInfo.append(this.formatContainerInfo(containerName, "install", schemaVersion));
                ++pdbInstallCount;
                upgradeMsg.append(this.getContainerInstallMsg(containerName, productVersion, false)).append(this.getContainerModeMsg(mode, restricted)).append("\n");
                continue;
            }
            if (this.isUpgrade(schemaVersion, productVersion)) {
                if (conInfo.length() > 0) {
                    conInfo.append("|");
                }
                conInfo.append(this.formatContainerInfo(containerName, "upgrade", schemaVersion));
                if (isRoot) {
                    upgradeMsg.append(this.getContainerUpgradeMsg(containerName, productVersion, schemaVersion)).append(" ").append(this.getContainerModeMsg(mode, restricted)).append("\n");
                    continue;
                }
                upgradeMsg.append(containerName);
                continue;
            }
            if (!this.isInvalidProductVersion(schemaVersion, productVersion)) continue;
            errMsg.append(SetupMessages.format(conKey, containerName, SetupMessages.format("ERR_PDB_MISMATCH_VERSION", productVersion, schemaVersion))).append("\n");
        }
        if (errMsg.length() > 0) {
            installParams.put("installer", "skip");
            LOG.info(SetupMessages.format("ERR_CDB_INSTALL_PDB_EXISTS", errMsg.toString()));
            return;
        }
        if (conInfo.length() > 0) {
            LOG.fine("conInfo :" + conInfo.toString());
            if (!isRoot && dbType.equals(PDB) && (installStatus.equals(COMMON_ALL_ORDS_INSTALLED) || installStatus.equals(COMMON_USERS_ORDS_INSTALLED))) {
                installParams.put("installer", "skip");
                LOG.info(SetupMessages.format("ERR_UPGRADE_ROOT_CONTAINS_ORDS", upgradeMsg.toString()));
                return;
            }
            boolean upgrade = true;
            if (isRoot) {
                String msg = SetupMessages.format("CDB_UPGRADE_COMMON_OBJS", upgradeMsg.toString());
                LOG.console(msg);
                String msgArg = null;
                msgArg = upgradeCount > 0 && pdbInstallCount > 0 ? SetupMessages.getString("INSTALL_AND_UPGRADE") : (pdbInstallCount > 0 ? SetupMessages.getString("INSTALL") : SetupMessages.getString("UPGRADE"));
                upgrade = this.requestToContinue(installParams, "upgrade", msgArg);
            }
            if (upgrade) {
                if (isRoot && pdbInstallCount > 0) {
                    this.retrieveRootTablespaces(conn, installParams);
                }
                installParams.put("containers.info", conInfo.toString());
                if (isRoot) {
                    installParams.put("installer", "cdb.upgrade");
                    installParams.put("schema.version", "");
                } else {
                    installParams.put("installer", "upgrade");
                    installParams.put("schema.version", schemaVersion);
                }
            } else {
                installParams.put("installer", "skip");
            }
        } else if (!isRoot) {
            installParams.put("installer", "skip");
        }
    }

    private void verifyUninstall(Connection conn, Map<String, String> installParams, Map<String, String[]> containers, boolean isRoot) throws Exception {
        StringBuilder errMsg = new StringBuilder();
        StringBuilder uninstallMsg = new StringBuilder();
        StringBuilder conInfo = new StringBuilder();
        String dbType = null;
        String name = null;
        for (String containerName : containers.keySet()) {
            String[] values = containers.get(containerName);
            String mode = values[1];
            String restricted = values[2];
            String version = values[3];
            String conErrorMsg = values[5];
            dbType = values[6];
            name = containerName;
            if (!NullOrEmpty.nullOrEmpty((CharSequence)conErrorMsg)) {
                errMsg.append(conErrorMsg).append("\n");
            }
            if (conInfo.length() > 0) {
                conInfo.append("|");
            }
            conInfo.append(this.formatContainerInfo(containerName, "uninstall", version));
            uninstallMsg.append(this.getContainerUninstallMsg(containerName, version)).append(" ").append(this.getContainerModeMsg(mode, restricted)).append("\n");
        }
        if (errMsg.length() > 0) {
            LOG.console(errMsg.toString());
        }
        if (conInfo.length() > 0) {
            LOG.fine("conInfo :" + conInfo.toString());
            boolean uninstall = true;
            if (isRoot) {
                LOG.console(SetupMessages.format("CDB_UNINSTALL_COMMON_OBJS", uninstallMsg.toString()));
                uninstall = this.requestToContinue(installParams, "uninstall");
            }
            if (uninstall) {
                installParams.put("containers.info", conInfo.toString());
                installParams.put("schema.version", "");
                if (isRoot) {
                    installParams.put("installer", "cdb.uninstall");
                } else {
                    installParams.put("installer", "uninstall");
                    if (dbType.equals(PDB) && CdbPdbSetup.isOrdsInstalledRootContainer(conn, name)) {
                        installParams.put("cdb.install", "true");
                    }
                }
            } else {
                installParams.put("installer", "skip");
            }
        } else {
            installParams.put("installer", "skip");
        }
    }

    private void verifyRestart(Connection conn, Map<String, String> installParams, Map<String, String[]> containers, boolean isRoot) throws Exception {
        String productVersion = installParams.get("product.version");
        StringBuilder restartMsg = new StringBuilder();
        StringBuilder errMsg = new StringBuilder();
        StringBuilder conInfo = new StringBuilder();
        for (String containerName : containers.keySet()) {
            String[] values = containers.get(containerName);
            String mode = values[1];
            String restricted = values[2];
            String schemaVersion = values[3];
            String processType = values[7];
            String conErrorMsg = values[5];
            if (!NullOrEmpty.nullOrEmpty((CharSequence)conErrorMsg)) {
                errMsg.append(conErrorMsg).append("\n");
                continue;
            }
            if (conInfo.length() > 0) {
                conInfo.append("|");
            }
            conInfo.append(this.formatContainerInfo(containerName, processType, schemaVersion));
            if (processType.equals("install")) {
                restartMsg.append(this.getContainerInstallMsg(containerName, productVersion, false)).append(this.getContainerModeMsg(mode, restricted)).append("\n");
                continue;
            }
            if (!processType.equals("upgrade")) continue;
            restartMsg.append(this.getContainerUpgradeMsg(containerName, productVersion, schemaVersion)).append(" ").append(this.getContainerModeMsg(mode, restricted)).append("\n");
        }
        if (conInfo.length() > 0) {
            String conInfoStr = conInfo.toString();
            LOG.fine("conInfo :" + conInfo.toString());
            boolean restart = true;
            LOG.console(SetupMessages.format("CDB_RESTART_COMMON_OBJS", restartMsg.toString()));
            String msgArg = null;
            msgArg = conInfoStr.contains("install") && conInfoStr.contains("upgrade") ? SetupMessages.getString("INSTALL_AND_UPGRADE") : SetupMessages.getString("UPGRADE");
            restart = this.requestToContinue(installParams, "restart.only", msgArg);
            if (restart) {
                installParams.put("containers.info", conInfoStr);
                installParams.put("schema.version", "");
                installParams.put("installer", "cdb.upgrade");
            } else {
                installParams.put("installer", "skip");
            }
        } else {
            if (errMsg.length() > 0) {
                LOG.console(SetupMessages.format("CDB_RESTART_ERR_COMMON_OBJS", errMsg.toString()));
            }
            installParams.put("installer", "skip");
        }
    }

    private void verifyValidate(Connection conn, Map<String, String> installParams, Map<String, String[]> containers, boolean isRoot) throws Exception {
        StringBuilder errMsg = new StringBuilder();
        StringBuilder validateMsg = new StringBuilder();
        StringBuilder conInfo = new StringBuilder();
        String productVersion = installParams.get("product.version");
        String name = null;
        String dbType = null;
        String schemaVersion = null;
        String installStatus = null;
        for (String containerName : containers.keySet()) {
            String[] values = containers.get(containerName);
            String conErrorMsg = values[5];
            String conKey = containerName.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
            name = containerName;
            dbType = values[6];
            schemaVersion = values[3];
            installStatus = values[4];
            if (!NullOrEmpty.nullOrEmpty((CharSequence)conErrorMsg)) {
                errMsg.append(conErrorMsg).append("\n");
                continue;
            }
            if (this.sameVersionJuilianDay(productVersion, schemaVersion)) {
                if (conInfo.length() > 0) {
                    conInfo.append("|");
                }
                conInfo.append(this.formatContainerInfo(containerName, "validate", schemaVersion));
                validateMsg.append(SetupMessages.format(conKey, containerName, SetupMessages.format("CON_VALIDATE", schemaVersion))).append("\n");
                continue;
            }
            if (this.isInstall(schemaVersion, installStatus)) {
                errMsg.append(SetupMessages.format(conKey, containerName, SetupMessages.getString("CON_ORDS_NOT_EXIST"))).append("\n");
                continue;
            }
            if (this.isUpgrade(schemaVersion, productVersion)) {
                errMsg.append(SetupMessages.format(conKey, containerName, SetupMessages.format("CON_VERSION_INVALID", productVersion, schemaVersion))).append("\n");
                continue;
            }
            if (!this.isInvalidProductVersion(schemaVersion, productVersion)) continue;
            errMsg.append(SetupMessages.format(conKey, containerName, SetupMessages.format("CON_VERSION_INVALID", productVersion, schemaVersion))).append("\n");
        }
        if (errMsg.length() > 0) {
            installParams.put("installer", "skip");
            if (isRoot) {
                LOG.info(SetupMessages.format("ERR_VALIDATE_CDB", errMsg.toString()));
            } else {
                LOG.info(SetupMessages.format("ERR_VALIDATE", errMsg.toString()));
            }
            return;
        }
        if (conInfo.length() > 0) {
            LOG.fine("conInfo :" + conInfo.toString());
            if (!isRoot && dbType.equals(PDB) && CdbPdbSetup.isOrdsInstalledRootContainer(conn, name)) {
                installParams.put("installer", "skip");
                LOG.info(SetupMessages.format("ERR_ROOT_CONTAINS_ORDS_VALIDATE", name));
                return;
            }
            String msg = isRoot ? SetupMessages.format("CDB_VALIDATE_COMMON_OBJS", validateMsg.toString()) : SetupMessages.getString("VALIDATE_MSG");
            LOG.console(msg);
            boolean validate = true;
            if (isRoot) {
                validate = this.requestToContinue(installParams, "validate");
            }
            if (validate) {
                installParams.put("containers.info", conInfo.toString());
                if (isRoot) {
                    installParams.put("installer", "cdb.validate");
                    installParams.put("schema.version", "");
                } else {
                    installParams.put("installer", "validate");
                    installParams.put("schema.version", schemaVersion);
                }
            } else {
                installParams.put("installer", "skip");
            }
        } else {
            installParams.put("installer", "skip");
        }
    }

    private boolean isInstall(String version, String ordsInstallType) {
        return NullOrEmpty.nullOrEmpty((CharSequence)version) && !NullOrEmpty.nullOrEmpty((CharSequence)ordsInstallType) && ordsInstallType.equals(ORDS_NOT_INSTALLED);
    }

    private boolean isUpgrade(String schemaVersion, String productVersion) throws Exception {
        return VersionFormat.isEarlierVersion((String)schemaVersion, (String)productVersion);
    }

    private boolean isInvalidProductVersion(String schemaVersion, String productVersion) throws Exception {
        return VersionFormat.isEarlierVersion((String)productVersion, (String)schemaVersion);
    }

    private boolean isOrdsInstalled(String version, String installStatus) {
        return installStatus.equals(COMMON_USERS_ONLY) || !NullOrEmpty.nullOrEmpty((CharSequence)version) && (installStatus.equals(COMMON_ALL_ORDS_INSTALLED) || installStatus.equals(COMMON_USERS_ORDS_INSTALLED) || installStatus.equals(ORDS_INSTALLED));
    }

    private boolean requestToContinue(Map<String, String> installParams, String requestType) throws Exception {
        return this.requestToContinue(installParams, requestType, null);
    }

    private boolean requestToContinue(Map<String, String> installParams, String requestType, String msgArg) throws Exception {
        Console console;
        String isInstall;
        boolean isSilentMode = InstallParams.simpleInstall(installParams);
        if (isSilentMode && installParams.containsKey("rest.services.ords.add") && !NullOrEmpty.nullOrEmpty((CharSequence)(isInstall = installParams.get("rest.services.ords.add")))) {
            if (isInstall.equals("true")) {
                return true;
            }
            if (isInstall.equals("false")) {
                return false;
            }
        }
        if ((console = System.console()) != null) {
            String choice = null;
            String msgKey = null;
            msgKey = requestType.equals("install") ? "PROMPT_CDB_INSTALL" : (requestType.equals("upgrade") || requestType.equals("restart.only") ? "PROMPT_CDB_UPGRADE" : (requestType.equals("uninstall") ? "PROMPT_CDB_UNINSTALL" : (requestType.equals("validate") ? "PROMPT_CDB_VALIDATE" : "PROMPT_CDB_UPGRADE")));
            PROMPT_CDB_PDB_PROCESSING.setMessageKey(msgKey);
            choice = !NullOrEmpty.nullOrEmpty((CharSequence)msgArg) ? PROMPT_CDB_PDB_PROCESSING.prompt(console, msgArg) : PROMPT_CDB_PDB_PROCESSING.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                installParams.put("rest.services.ords.add", "true");
                return true;
            }
            installParams.put("rest.services.ords.add", "false");
            return false;
        }
        throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
    }

    private Map<String, String[]> getContainersToProcess(Connection conn, Map<String, String> installParams, String processTypeMsg) throws Exception {
        return this.getContainersToProcess(conn, installParams, processTypeMsg, false);
    }

    private Map<String, String[]> getContainersToProcess(Connection conn, Map<String, String> installParams, String processTypeMsg, boolean createConModeMap) throws Exception {
        boolean skipReadOnly = false;
        if (installParams.containsKey("pdb.skip.readonly")) {
            skipReadOnly = Boolean.valueOf(installParams.get("pdb.skip.readonly"));
        }
        boolean skipClosed = false;
        if (installParams.containsKey("pdb.skip.closed")) {
            skipClosed = Boolean.valueOf(installParams.get("pdb.skip.closed"));
        }
        Set<String> pdbsOpenReadWrite = this.getPdbsOpenReadWrite(installParams.get("pdb.open.readwrite"));
        Map<String, String[]> containers = this.getContainersInfo(conn, ALL_CONTAINERS_INFO_SQL);
        if (NullOrEmpty.nullOrEmpty(containers)) {
            throw new Exception(SetupMessages.getString("ERR_CON_INFO_MISSING"));
        }
        LinkedHashMap<String, String[]> processContainers = new LinkedHashMap<String, String[]>();
        StringBuilder errMsg = new StringBuilder();
        if (createConModeMap) {
            this.conModeMap = new HashMap<String, String[]>();
        }
        for (String name : containers.keySet()) {
            String conKeyMsg;
            String[] values = containers.get(name);
            String mode = values[1];
            String string = conKeyMsg = name.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
            if (createConModeMap) {
                this.conModeMap.put(name, values);
            }
            if (mode.equals(READ_WRITE)) {
                processContainers.put(name, values);
                continue;
            }
            if (mode.equals(READ_ONLY)) {
                if (pdbsOpenReadWrite.contains(name)) {
                    processContainers.put(name, values);
                    continue;
                }
                if (skipReadOnly) continue;
                errMsg.append(SetupMessages.format(conKeyMsg, name, mode)).append("\n");
                continue;
            }
            if (mode.equals(MOUNTED)) {
                if (skipClosed) continue;
                errMsg.append(SetupMessages.format(conKeyMsg, name, mode)).append("\n");
                continue;
            }
            if (!mode.equals(MIGRATE)) continue;
            processContainers.put(name, values);
        }
        if (errMsg.length() != 0) {
            installParams.put("installer", "skip");
            throw new Exception(SetupMessages.format("ERR_CON_REQUIRES_READ_WRITE", processTypeMsg, errMsg.toString()));
        }
        return processContainers;
    }

    private void containerTablespaces(Connection conn, Map<String, String> installParams, Map<String, String[]> containers) throws Exception {
        boolean isSilentInstall = InstallParams.simpleInstall(installParams);
        if (isSilentInstall && NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("schema.tablespace.default")) && NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("schema.tablespace.temp")) && NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("user.tablespace.default")) && NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("user.tablespace.temp"))) {
            installParams.put("schema.tablespace.default", "-DEFAULT");
            installParams.put("schema.tablespace.temp", "-DEFAULT");
            installParams.put("user.tablespace.default", "-DEFAULT");
            installParams.put("user.tablespace.temp", "-DEFAULT");
        } else {
            Console console = System.console();
            this.promptTablespace(console, conn, installParams, containers, "schema.tablespace.default", SYSAUX_TBS, "ORDS_METADATA", false);
            this.promptTablespace(console, conn, installParams, containers, "schema.tablespace.temp", TEMP_TBS, "ORDS_METADATA", true);
            String defTbsSchema = installParams.get("schema.tablespace.default");
            String defTbsPublic = installParams.get("user.tablespace.default");
            if (NullOrEmpty.nullOrEmpty((CharSequence)defTbsPublic) || !defTbsPublic.equalsIgnoreCase(defTbsSchema) || !isSilentInstall) {
                this.promptTablespace(console, conn, installParams, containers, "user.tablespace.default", SYSAUX_TBS, "ORDS_PUBLIC_USER", false);
            }
            String tmpTbsSchema = installParams.get("schema.tablespace.default");
            String tmpTbsPublic = installParams.get("user.tablespace.default");
            if (NullOrEmpty.nullOrEmpty((CharSequence)tmpTbsPublic) || !tmpTbsPublic.equalsIgnoreCase(tmpTbsSchema) || !isSilentInstall) {
                this.promptTablespace(console, conn, installParams, containers, "user.tablespace.temp", TEMP_TBS, "ORDS_PUBLIC_USER", true);
            }
        }
    }

    private void promptTablespace(Console console, Connection conn, Map<String, String> installParams, Map<String, String[]> containers, String tbsTypeKey, String tbsDefaultValue, String msgUserName, boolean isTempTbs) throws Exception {
        String tbsType;
        boolean isSilentMode = InstallParams.simpleInstall(installParams);
        String tbsName = null;
        boolean isValid = false;
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get(tbsTypeKey))) {
            tbsName = installParams.get(tbsTypeKey).toUpperCase();
            boolean showMsg = true;
            if (tbsName.equals(USERS_TBS) && tbsTypeKey.equals("user.tablespace.default") && msgUserName.equals("ORDS_PUBLIC_USER")) {
                showMsg = false;
            }
            isValid = this.isValidTablespace(conn, containers, tbsName, isTempTbs, showMsg);
            if (isSilentMode && isValid) {
                return;
            }
        }
        if (console == null) {
            if (isSilentMode) {
                if (tbsName == null) {
                    throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", tbsTypeKey));
                }
                throw new Exception(SetupMessages.getString(SetupMessages.format("ERR_INVALID_TBS_PARAMFILE", tbsTypeKey, tbsName)));
            }
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        if (!(isValid || tbsName != null && tbsName.equals(tbsDefaultValue))) {
            tbsName = tbsDefaultValue;
            isValid = this.isValidTablespace(conn, containers, tbsName, isTempTbs, false);
        }
        if (isValid) {
            PROMPT_TABLESPACE.setDefaultValue(tbsName);
        } else {
            tbsName = null;
        }
        boolean valid = false;
        int maxTries = 0;
        String tbsValue = null;
        String string = tbsType = isTempTbs ? SetupMessages.getString("TEMPORARY_TBS") : SetupMessages.getString("DEFAULT_TBS");
        while (!valid && maxTries < 10) {
            tbsValue = PROMPT_TABLESPACE.prompt(console, tbsType, msgUserName);
            valid = tbsName != null && tbsValue.equals(tbsName) ? true : this.isValidTablespace(conn, containers, tbsValue, isTempTbs, true);
            if (valid) continue;
            ++maxTries;
        }
        if (!valid) {
            throw new Exception(SetupMessages.format("ERR_MAX_EXCEEDED_TBS", tbsType, msgUserName));
        }
        installParams.put(tbsTypeKey, tbsValue);
    }

    private boolean isValidTablespace(Connection conn, Map<String, String[]> containers, String tbsName, boolean isTempTbs, boolean showMsg) throws Exception {
        if (containers.containsKey(CDB_ROOT)) {
            return this.isValidContainerTablespace(conn, containers, tbsName, isTempTbs, showMsg);
        }
        return this.isValidTablespace(conn, tbsName, isTempTbs, showMsg);
    }

    private boolean isValidTablespace(Connection conn, String tbsName, boolean isTempTbs, boolean showMsg) throws Exception {
        String key;
        String errMsg = null;
        String invalidTbsName = null;
        if (!isTempTbs && !NullOrEmpty.nullOrEmpty((CharSequence)(invalidTbsName = this.tablespaceQuery(conn, tbsName, TEMP_TBS_SQL))) && (errMsg = SetupMessages.format("ERR_DEF_TBS_INVALID", SetupMessages.getString("DEFAULT_TBS"), tbsName)) != null) {
            if (showMsg) {
                LOG.info(errMsg);
            } else {
                LOG.fine(errMsg);
            }
            return false;
        }
        String sql = isTempTbs ? TEMP_TBS_SQL : DEF_TBS_SQL;
        String tbsNameExist = this.tablespaceQuery(conn, tbsName, sql);
        if (NullOrEmpty.nullOrEmpty((CharSequence)tbsNameExist) && (errMsg = SetupMessages.format("ERR_TABLESPACE_MISSING", SetupMessages.getString(key = isTempTbs ? "TEMPORARY_TBS" : "DEFAULT_TBS"), tbsName)) != null) {
            if (showMsg) {
                LOG.info(errMsg);
            } else {
                LOG.fine(errMsg);
            }
            return false;
        }
        return true;
    }

    private boolean isValidContainerTablespace(Connection conn, Map<String, String[]> containers, String tbsName, boolean isTempTbs, boolean showMsg) throws Exception {
        String errMsg = null;
        List<String> consTbsInvalid = null;
        if (!isTempTbs && !(consTbsInvalid = this.containerTablespaceQuery(conn, tbsName, CON_TEMP_TBS_EXIST_SQL)).isEmpty() && (errMsg = this.checkInvalidTableSpace(containers, consTbsInvalid, isTempTbs, "ERR_CON_DEF_TBS_INVALID", tbsName)) != null) {
            if (showMsg) {
                LOG.info(errMsg);
            } else {
                LOG.fine(errMsg);
            }
            return false;
        }
        String sql = isTempTbs ? CON_TEMP_TBS_NOT_EXIST_SQL : CON_DEF_TBS_NOT_EXIST_SQL;
        consTbsInvalid = this.containerTablespaceQuery(conn, tbsName, sql);
        if (!consTbsInvalid.isEmpty() && (errMsg = this.checkInvalidTableSpace(containers, consTbsInvalid, isTempTbs, "ERR_CON_TABLESPACE_MISSING", tbsName)) != null) {
            if (showMsg) {
                LOG.info(errMsg);
            } else {
                LOG.fine(errMsg);
            }
            return false;
        }
        return true;
    }

    private String checkInvalidTableSpace(Map<String, String[]> containers, List<String> consTbsInvalid, boolean isTempTbs, String errMsgKey, String tbsName) {
        StringBuilder errMsg = new StringBuilder();
        String tbsTypeMsg = isTempTbs ? SetupMessages.getString("TEMPORARY_TBS") : SetupMessages.getString("DEFAULT_TBS");
        for (String name : consTbsInvalid) {
            if (!containers.containsKey(name)) continue;
            errMsg.append(' ').append(name);
        }
        String msg = null;
        if (errMsg.length() > 0) {
            msg = SetupMessages.format(errMsgKey, tbsTypeMsg, tbsName, errMsg.toString(), tbsTypeMsg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> containerTablespaceQuery(Connection conn, String tblspaceName, String sql) throws Exception {
        ArrayList<String> containers = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, tblspaceName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                containers.add(rs.getString("name"));
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{rs, stmt});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{rs, stmt});
        return containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tablespaceQuery(Connection conn, String tblspaceName, String sql) throws Exception {
        String tbsName = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, tblspaceName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                tbsName = rs.getString("tablespace_name");
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{rs, stmt});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{rs, stmt});
        return tbsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveRootTablespaces(Connection conn, Map<String, String> installParams) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(ROOT_TBS_SQL);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String username = rs.getString("username");
                String defaultTbs = rs.getString("default_tablespace");
                String tempTbs = rs.getString("temporary_tablespace");
                if (username.equals("ORDS_METADATA")) {
                    installParams.put("schema.tablespace.default", defaultTbs);
                    installParams.put("schema.tablespace.temp", tempTbs);
                    continue;
                }
                if (!username.equals("ORDS_PUBLIC_USER")) continue;
                installParams.put("user.tablespace.default", defaultTbs);
                installParams.put("user.tablespace.temp", tempTbs);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{rs, stmt});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{rs, stmt});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containersORDSVersion(Connection conn, Map<String, String[]> containers) throws Exception {
        boolean useAlterStmt = containers.size() > 1;
        StringBuilder errMsg = new StringBuilder();
        Statement alterStmt = null;
        CallableStatement callStmt = null;
        try {
            if (useAlterStmt) {
                alterStmt = ((OracleConnection)conn).createStatement();
            }
            callStmt = conn.prepareCall(GET_ORDS_VERSION_SQL);
            for (String containerName : containers.keySet()) {
                String[] values = containers.get(containerName);
                String mode = values[1];
                if (!NullOrEmpty.nullOrEmpty((CharSequence)mode) && mode.equals(MOUNTED)) continue;
                if (useAlterStmt) {
                    alterStmt.executeUpdate(ALTER_SET_CONTAINER_SQL + containerName);
                }
                callStmt.registerOutParameter(1, 12);
                callStmt.registerOutParameter(2, 12);
                callStmt.registerOutParameter(3, 4);
                callStmt.registerOutParameter(4, 4);
                callStmt.registerOutParameter(5, 12);
                callStmt.registerOutParameter(6, 12);
                callStmt.registerOutParameter(7, 4);
                callStmt.execute();
                String version = callStmt.getString(1);
                int errNum = callStmt.getInt(2);
                int totalUsers = callStmt.getInt(3);
                int versionViewExists = callStmt.getInt(4);
                String commonOrdsSchema = callStmt.getString(5);
                String commonPubUser = callStmt.getString(6);
                int viewOriginConId = callStmt.getInt(7);
                String string = values[3] = NullOrEmpty.nullOrEmpty((CharSequence)version) ? "" : version;
                if (totalUsers == 0) {
                    values[4] = ORDS_NOT_INSTALLED;
                } else if (totalUsers == 2) {
                    if (containerName.equals(CDB_ROOT)) {
                        values[4] = versionViewExists == 0 ? COMMON_USERS_ONLY : COMMON_ALL_ORDS_INSTALLED;
                    } else if (versionViewExists > 0) {
                        values[4] = commonOrdsSchema.equals(YES) && commonPubUser.equals(YES) ? (viewOriginConId == 1 ? COMMON_ALL_ORDS_INSTALLED : COMMON_USERS_ORDS_INSTALLED) : ORDS_INSTALLED;
                    }
                } else {
                    values[4] = UNKNOWN;
                }
                if (errNum > 0) {
                    String err = null;
                    if (errNum == 100) {
                        err = SetupMessages.getString("ERR_MISSING_VERSION");
                    } else if (errNum == 101) {
                        err = SetupMessages.getString("ERR_MISSING_SCHEMA");
                    } else if (errNum == 102) {
                        err = SetupMessages.getString("ERR_MISSING_PUBLIC_USER");
                    }
                    String conKeyMsg = containerName.equals(CDB_ROOT) ? "CON_ROOT_MSG" : "CON_PDB_MSG";
                    values[5] = SetupMessages.format(conKeyMsg, containerName, err);
                    errMsg.append(values[5]).append("\n");
                }
                containers.put(containerName, values);
            }
            if (useAlterStmt) {
                alterStmt.executeUpdate("alter session set container = CDB$ROOT");
            }
            if (errMsg.length() > 0) {
                LOG.fine(errMsg.toString());
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{callStmt, alterStmt});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{callStmt, alterStmt});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean[] getContainerFlags(Connection conn) throws SQLException {
        Boolean[] conFlags = new Boolean[2];
        boolean isRoot = false;
        boolean isCdb = false;
        CallableStatement callStmt = null;
        try {
            callStmt = conn.prepareCall(GET_CDB_INFO);
            callStmt.registerOutParameter(1, 12);
            callStmt.registerOutParameter(2, 12);
            callStmt.registerOutParameter(3, 12);
            callStmt.registerOutParameter(4, 12);
            callStmt.execute();
            String cdb = callStmt.getString(1);
            String isRootStr = callStmt.getString(2);
            String conName = callStmt.getString(3);
            String sessUser = callStmt.getString(4);
            if (!NullOrEmpty.nullOrEmpty((CharSequence)cdb) && cdb.equals(YES)) {
                isCdb = true;
            }
            isRoot = Boolean.parseBoolean(callStmt.getString(2));
            conFlags[0] = isCdb;
            conFlags[1] = isRoot;
            LOG.fine(" cdb=" + cdb + " isRootStr=" + isRootStr + " conName=" + conName + " sessUser=" + sessUser);
        }
        finally {
            Closeables.close((Object)callStmt);
        }
        return conFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDBVersion(Connection conn) throws SQLException {
        CallableStatement callStmt = null;
        int dbVersion = 0;
        try {
            callStmt = conn.prepareCall("begin ? := SYS.DBMS_DB_VERSION.VERSION; end;");
            callStmt.registerOutParameter(1, 4);
            callStmt.execute();
            dbVersion = callStmt.getInt(1);
        }
        finally {
            Closeables.close((Object)callStmt);
        }
        return dbVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCDBRoot(Connection conn) throws SQLException {
        boolean isRoot = false;
        CallableStatement callStmt = null;
        try {
            callStmt = conn.prepareCall(IS_CDB_ROOT);
            callStmt.registerOutParameter(1, 12);
            callStmt.execute();
            isRoot = Boolean.parseBoolean(callStmt.getString(1));
        }
        finally {
            Closeables.close((Object)callStmt);
        }
        LOG.fine("isCDBRoot() isRoot = " + isRoot);
        return isRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOrdsInstalledRootContainer(Connection conn, String pdbName) throws Exception {
        Statement alterStmt = null;
        Statement userStmt = null;
        ResultSet rs = null;
        int totalUsers = 0;
        try {
            alterStmt = ((OracleConnection)conn).createStatement();
            alterStmt.executeUpdate("alter session set container = CDB$ROOT");
            userStmt = conn.createStatement();
            rs = userStmt.executeQuery("select count(*) from all_users where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')");
            if (!rs.next()) {
                throw new Exception("Error cannot get the total count of ords users.");
            }
            totalUsers = rs.getInt(1);
        }
        catch (Throwable throwable) {
            alterStmt.executeUpdate(ALTER_SET_CONTAINER_SQL + pdbName);
            Closeables.close((Object[])new Object[]{alterStmt, userStmt, rs});
            throw throwable;
        }
        alterStmt.executeUpdate(ALTER_SET_CONTAINER_SQL + pdbName);
        Closeables.close((Object[])new Object[]{alterStmt, userStmt, rs});
        return totalUsers > 0;
    }

    private Map<String, String[]> getNonCdbInfo() throws Exception {
        HashMap<String, String[]> nonCdb = new HashMap<String, String[]>();
        String[] info = new String[8];
        String name = NON_CDB;
        info[6] = NON_CDB;
        nonCdb.put(name, info);
        return nonCdb;
    }

    private Map<String, String[]> getPublicUserInfo() throws Exception {
        HashMap<String, String[]> pubUserInfo = new HashMap<String, String[]>();
        String[] info = new String[8];
        String name = "ORDS_PUBLIC_USER";
        pubUserInfo.put(name, info);
        return pubUserInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String[]> getContainersInfo(Connection conn, String sql) throws Exception {
        LinkedHashMap<String, String[]> containers = new LinkedHashMap<String, String[]>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String[] info = new String[8];
                info[0] = rs.getString("con_id");
                info[1] = rs.getString("open_mode");
                info[2] = rs.getString("restricted");
                String name = rs.getString("name");
                info[6] = name.equals(CDB_ROOT) ? CDB : PDB;
                containers.put(name, info);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{rs, stmt});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{rs, stmt});
        return containers;
    }

    private Set<String> getPdbsOpenReadWrite(String pdbs) {
        String[] listPdbs;
        LinkedHashSet<String> pdbsOpenReadWrite = new LinkedHashSet<String>();
        if (!NullOrEmpty.nullOrEmpty((CharSequence)pdbs) && (listPdbs = pdbs.split(",")).length > 0) {
            for (String name : listPdbs) {
                pdbsOpenReadWrite.add(name.toUpperCase());
            }
        }
        pdbsOpenReadWrite.add(PDB_SEED);
        return pdbsOpenReadWrite;
    }

    private String formatContainerInfo(String name, String processType, String version) {
        StringBuilder fmt = new StringBuilder();
        fmt.append(name).append("^").append(processType).append("^");
        if (!NullOrEmpty.nullOrEmpty((CharSequence)version)) {
            fmt.append(version);
        } else {
            fmt.append(NULL_STR);
        }
        return fmt.toString();
    }

    private String getContainerInstallMsg(String name, String prodVer, boolean isCdbCommonUsersOption) {
        String conKeyMsg = "CON_PDB_MSG";
        String msg = SetupMessages.format("CON_INSTALL", prodVer);
        if (name.equals(CDB_ROOT)) {
            conKeyMsg = "CON_ROOT_MSG";
            if (isCdbCommonUsersOption) {
                msg = SetupMessages.getString("CON_CREATE_COMMON_USERS");
            }
        }
        return SetupMessages.format(conKeyMsg, name, msg);
    }

    private String getContainerUpgradeMsg(String name, String prodVer, String schemaVer) {
        String conKeyMsg = "CON_PDB_MSG";
        String msg = SetupMessages.format("CON_UPGRADE", schemaVer, prodVer);
        if (name.equals(CDB_ROOT)) {
            conKeyMsg = "CON_ROOT_MSG";
        }
        return SetupMessages.format(conKeyMsg, name, msg);
    }

    private String getContainerUninstallMsg(String name, String schemaVer) {
        String tmpSchemaVer = schemaVer;
        if (NullOrEmpty.nullOrEmpty((CharSequence)tmpSchemaVer) || tmpSchemaVer.equals(UNKNOWN)) {
            tmpSchemaVer = "";
        }
        String conKeyMsg = "CON_PDB_MSG";
        String msg = SetupMessages.format("CON_UNINSTALL", tmpSchemaVer);
        if (name.equals(CDB_ROOT)) {
            conKeyMsg = "CON_ROOT_MSG";
        }
        return SetupMessages.format(conKeyMsg, name, msg);
    }

    private String getContainerModeMsg(String mode, String restricted) {
        String msg = "";
        if (!NullOrEmpty.nullOrEmpty((CharSequence)mode) && mode.equals(READ_ONLY)) {
            String modeKeyMsg = !NullOrEmpty.nullOrEmpty((CharSequence)restricted) && restricted.equals(YES) ? "CON_MODE_RESTRICTED" : "CON_MODE";
            msg = SetupMessages.format("CON_MODE_OPEN_RW", SetupMessages.format(modeKeyMsg, mode));
        }
        return msg;
    }

    private boolean sameVersionJuilianDay(String productVer, String schemaVer) {
        return !NullOrEmpty.nullOrEmpty((CharSequence)schemaVer) && !NullOrEmpty.nullOrEmpty((CharSequence)productVer) && VersionFormat.getReleaseFormat((String)productVer).equals(VersionFormat.getReleaseFormat((String)schemaVer));
    }
}

