/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.common.config.PropertiesConfiguration;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;

class RoleMappings {
    private final AssociativeArray<URITemplate, List<URITemplate>> mappings;
    private static final Log LOG = Log.get(RoleMappings.class);

    RoleMappings(AssociativeArray<String, String> roleMappings) {
        this(RoleMappings.build(roleMappings), null);
    }

    RoleMappings(File file) throws IOException {
        this(RoleMappings.read(file));
    }

    RoleMappings add(AssociativeArray<String, String> roleMappings) {
        return new RoleMappings((AssociativeArray<URITemplate, List<URITemplate>>)AssociativeArrays.merge(RoleMappings.build(roleMappings), this.mappings), null);
    }

    private RoleMappings(AssociativeArray<URITemplate, List<URITemplate>> mappings, Void avoidTypeErasureProblem) {
        this.mappings = mappings;
    }

    Collection<String> map(Iterable<String> roles) {
        ArrayDeque<String> working = new ArrayDeque<String>();
        Iterables.add(working, roles, (boolean)true);
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        while (!working.isEmpty()) {
            String role = (String)working.pop();
            all.add(role);
            for (URITemplate from : this.mappings) {
                if (!from.matches(role)) continue;
                List targets = (List)this.mappings.get((Object)from);
                for (URITemplate target : targets) {
                    Map<String, String> params;
                    String encoded = target.encode(params = from.decode(role));
                    if (all.contains(encoded)) continue;
                    working.addLast(encoded);
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Mapped: " + Iterables.join(roles, (String)", ") + " to: " + Iterables.join(all, (String)", "));
        }
        return all;
    }

    private static AssociativeArray<URITemplate, List<URITemplate>> build(AssociativeArray<String, String> roleMappings) {
        AssociativeArrays.Builder mappings = AssociativeArrays.builder();
        for (String f : roleMappings) {
            URITemplate from = URITemplates.uriTemplate(f);
            ArrayList<URITemplate> targets = new ArrayList<URITemplate>();
            for (String t : Text.commaDelimited((String)((String)roleMappings.get((Object)f)))) {
                URITemplate to = URITemplates.uriTemplate(t);
                targets.add(to);
            }
            mappings.add((Object)from, targets);
        }
        AssociativeArray built = mappings.build();
        return built;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AssociativeArray<String, String> read(File file) throws IOException {
        if (file.exists()) {
            InputStream in = null;
            try {
                PropertiesConfiguration roleMappings;
                in = Files.inputStream((File)file);
                PropertiesConfiguration propertiesConfiguration = roleMappings = new PropertiesConfiguration(in);
                return propertiesConfiguration;
            }
            finally {
                Closeables.close((Object)in);
            }
        }
        return AssociativeArrays.empty();
    }
}

