/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.apex;

import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.web.CustomHttpHeader;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ApexSessionDispatcher
extends ReTargetingDispatcher<ApexSessionTarget> {
    public static final String APEX_SESSION = "_apex_session";

    @Override
    protected EntityHeaders modifyRequestHeaders(ApexSessionTarget target, RequestEntity request) {
        return Entities.headers(CustomHttpHeader.APEX_SESSION, target.apexSession());
    }

    @Override
    protected ApexSessionTarget target(RequestEntity request) {
        QueryString queryString;
        String apexSession;
        if (Requests.isRead(request) && (apexSession = (String)(queryString = QueryString.parse((String)request.path())).get((Object)APEX_SESSION)) != null) {
            String originalPath = queryString.remove(APEX_SESSION).toString();
            return new ApexSessionTarget(originalPath, apexSession);
        }
        return null;
    }

    public static class ApexSessionTarget
    extends ReTargetingDispatcher.Target {
        private final String apexSession;

        public ApexSessionTarget(String target, String apexSession) {
            super(target);
            this.apexSession = apexSession;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApexSessionTarget other = (ApexSessionTarget)obj;
            return !(this.apexSession == null ? other.apexSession != null : !this.apexSession.equals(other.apexSession));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.apexSession == null ? 0 : this.apexSession.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ApexSessionTarget [apexSession=");
            builder.append(this.apexSession);
            builder.append("]");
            return builder.toString();
        }

        String apexSession() {
            return this.apexSession;
        }
    }
}

