/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.plugin.api.security.AuthorizationConstraint;
import oracle.dbtools.rt.authentication.SecurityConfig;

public class IdentityDomainSecurityConfig
extends SecurityConfig {
    private final AuthorizationConstraint authConstraint;

    public IdentityDomainSecurityConfig(SecurityConfig securityConfig, AuthorizationConstraint authConstraint) {
        super(securityConfig.constraint(), securityConfig.realm(), securityConfig.logonRealm());
        this.authConstraint = authConstraint;
    }

    @Override
    public AuthenticationStatus authorize(CompoundPrincipal principal) {
        Principal identity = principal.primary();
        boolean authorized = this.authConstraint.authorized(identity);
        if (!authorized) {
            return AuthenticationStatus.NOT_AUTHORIZED;
        }
        return super.authorize(principal);
    }
}

