/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.auth.HttpServletRequestCallback;
import oracle.dbtools.auth.domain.IdentityDomain;
import oracle.dbtools.auth.domain.IdentityDomainCallback;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.apex.SessionVerifierBase;

@Service(priority=2)
@Authenticates(value=AuthenticationRealm.RESOURCE_TEMPLATES)
public class ExternalSessionVerifier
extends SessionVerifierBase
implements RealmAuthenticator {
    private String externalRolesHeader;
    private String externalUserHeader;
    private String unauthenticatedUser;
    private boolean verifyOrigin = true;
    public static final String EXTERNAL_ROLES_HEADER = "security.externalRolesHeader";
    public static final String EXTERNAL_SESSION_VERIFY_ORIGIN = "security.externalSessionVerifyOrigin";
    public static final String EXTERNAL_UNAUTHENTICATED_USER = "security.externalUnauthenticatedUser";
    public static final String EXTERNAL_USER_HEADER = "security.externalUserHeader";

    public AuthenticationResult verify(CallbackHandler callbackHandler) {
        String user;
        if (!NullOrEmpty.nullOrEmpty((CharSequence)this.externalUserHeader) && !NullOrEmpty.nullOrEmpty((CharSequence)(user = this.externalUser(callbackHandler)))) {
            IdentityDomainCallback i = new IdentityDomainCallback();
            this.callback(callbackHandler, new Callback[]{i});
            IdentityDomain identityDomain = i.getIdentityDomain();
            String[] roles = new String[]{};
            if (!NullOrEmpty.nullOrEmpty((CharSequence)this.externalRolesHeader)) {
                HeaderCallback r = new HeaderCallback((CharSequence)this.externalRolesHeader);
                this.callback(callbackHandler, new Callback[]{r});
                String text = r.getValue();
                if (!NullOrEmpty.nullOrEmpty((CharSequence)text)) {
                    String[] roleNames = Text.commaDelimited((String)text);
                    ArrayList<String> validated = new ArrayList<String>(roleNames.length);
                    for (String role : roleNames) {
                        if (!identityDomain.isValidRole(role)) continue;
                        validated.add(role);
                    }
                    roles = validated.toArray(new String[validated.size()]);
                }
            }
            HeaderCallback o = new HeaderCallback((CharSequence)"Origin");
            HttpServletRequestCallback req = new HttpServletRequestCallback();
            this.callback(callbackHandler, new Callback[]{o, req});
            String origin = o.getValue();
            HttpServletRequest request = req.getRequest();
            if (this.verifyOrigin(origin, request)) {
                return this.authorize(callbackHandler, identityDomain, user, roles);
            }
        }
        return AuthenticationResult.unknown();
    }

    ExternalSessionVerifier externalRolesHeader(String externalRolesHeader) {
        this.externalRolesHeader = externalRolesHeader;
        return this;
    }

    ExternalSessionVerifier externalUserHeader(String externalUserHeader) {
        this.externalUserHeader = externalUserHeader;
        return this;
    }

    ExternalSessionVerifier unauthenticatdUser(String unauthenticatedUser) {
        this.unauthenticatedUser = unauthenticatedUser;
        return this;
    }

    ExternalSessionVerifier verifyOrigin(boolean verify) {
        this.verifyOrigin = verify;
        return this;
    }

    protected void activate(ServiceProperties props) {
        GlobalConfiguration conf = GlobalConfiguration.globalConfiguration();
        this.externalUserHeader = conf.get(EXTERNAL_USER_HEADER);
        this.externalRolesHeader = conf.get(EXTERNAL_ROLES_HEADER);
        this.verifyOrigin = (Boolean)PrimitiveTypes.valueOf((CharSequence)conf.get(EXTERNAL_SESSION_VERIFY_ORIGIN, "true"), Boolean.class);
        this.unauthenticatedUser = conf.get(EXTERNAL_UNAUTHENTICATED_USER, "NOT_FOUND");
        if (this.unauthenticatedUser.trim().isEmpty()) {
            this.unauthenticatedUser = null;
        }
    }

    private String externalUser(CallbackHandler callbackHandler) {
        HeaderCallback u = new HeaderCallback((CharSequence)this.externalUserHeader);
        this.callback(callbackHandler, new Callback[]{u});
        String user = u.getValue();
        if (!NullOrEmpty.nullOrEmpty((CharSequence)user)) {
            if (!NullOrEmpty.nullOrEmpty((CharSequence)this.unauthenticatedUser) && this.unauthenticatedUser.equals(user.trim())) {
                return null;
            }
            return user;
        }
        return null;
    }

    private boolean includePort(String scheme, int port) {
        boolean includePort = true;
        if (port > -1) {
            if ("http".equals(scheme) && 80 == port) {
                includePort = false;
            } else if ("https".equals(scheme) && 443 == port) {
                includePort = false;
            }
        } else {
            includePort = false;
        }
        return includePort;
    }

    private String serverOrigin(HttpServletRequest request) {
        StringBuilder b = new StringBuilder();
        String scheme = request.getScheme();
        b.append(scheme);
        b.append("://");
        b.append(request.getServerName());
        int port = request.getServerPort();
        if (this.includePort(scheme, port)) {
            b.append(':');
            b.append(port);
        }
        return b.toString();
    }

    private boolean verifyOrigin(String origin, HttpServletRequest request) {
        if (this.verifyOrigin) {
            String expected = this.serverOrigin(request);
            return origin == null || expected.equals(origin);
        }
        return true;
    }
}

