/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.http.ContentDisposition;
import oracle.dbtools.rt.cors.CrossOriginResourceSharing;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.web.HasResponse;
import oracle.dbtools.rt.web.HasSessionAttributes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

class ServletResponses {
    private final ServletContext ctx;
    private final HttpServletResponse response;
    private static final Log LOG = Log.get(ServletResponses.class);

    ServletResponses(ServletContext ctx, HttpServletResponse response) {
        this.ctx = ctx;
        this.response = response;
    }

    HttpServletResponse response() {
        return this.response;
    }

    void sendResponse(Entity response) throws IOException {
        InputStream body;
        EntityHeader statusCode;
        EntityHeaders headers = response.headers();
        this.setContentType(this.response, headers);
        this.setContentDisposition(this.response, headers);
        for (String header : headers) {
            if (header.toUpperCase().startsWith("X-APEX-") || HttpHeader.CONTENT_TYPE.matches(header) || HttpHeader.CONTENT_DISPOSITION.matches(header) || HttpHeader.LOCATION.matches(header)) continue;
            Iterable<String> values = headers.header(header).values();
            for (String value : values) {
                this.response.addHeader(header, value);
            }
        }
        EntityHeader loc = headers.header(HttpHeader.LOCATION);
        if (loc != null) {
            this.response.setHeader(HttpHeader.LOCATION.text(), this.location(response));
        }
        if ((statusCode = headers.header("X-APEX-STATUS-CODE")) != null) {
            this.response.setStatus(statusCode.intValue());
        }
        if (!this.isEmpty(body = response.body())) {
            ServletOutputStream outputStream = this.response.getOutputStream();
            StreamCopy.drain((InputStream)response.body(), (OutputStream)outputStream);
        }
        this.response.flushBuffer();
    }

    void sendResponse(RequestEntity request, HasResponse resource) throws IOException {
        if (request != null && resource instanceof HasSessionAttributes) {
            this.storeSessionState(request, this.response, (HasSessionAttributes)((Object)resource));
        }
        String requestPath = null;
        if (request != null) {
            requestPath = request.path();
        }
        String requestOrigin = CrossOriginResourceSharing.requestOrigin(request);
        Entity response = resource.response(request);
        EntityHeader allowOrigin = response.headers().header("Access-Control-Allow-Origin");
        if (requestOrigin != null && allowOrigin == null) {
            EntityHeadersBuilder corsEnabled = Entities.headers();
            corsEnabled.headers(response.headers());
            CrossOriginResourceSharing.corsEnableErrorResponseHeaders(requestOrigin, corsEnabled);
            response = Entities.entity(response.body(), corsEnabled.build());
        }
        this.sendResponse(requestPath, response);
    }

    void sendResponse(String requestPath, Entity response) throws IOException {
        Entity withContentType = this.determineContentType(requestPath, response);
        this.sendResponse(withContentType);
    }

    private Entity determineContentType(String requestPath, Entity entity) {
        try {
            HttpStatusCode sc;
            EntityHeaders headers = entity.headers();
            String contentType = null;
            EntityHeader ct = headers.header(HttpHeader.CONTENT_TYPE);
            if (!NullOrEmpty.nullOrEmpty((Iterable)ct)) {
                contentType = ct.value();
            }
            if (this.unknown(contentType) && (sc = HttpStatusCode.statusCode(entity)).hasBody() && !StreamCopy.isEmptyStream((InputStream)entity.body())) {
                String location = this.location(entity);
                if (location != null) {
                    contentType = this.ctx.getMimeType(location);
                } else if (requestPath != null) {
                    contentType = this.ctx.getMimeType(requestPath);
                }
                if (!this.unknown(contentType)) {
                    entity = Entities.merge(entity, Entities.headers(HttpHeader.CONTENT_TYPE, contentType));
                }
            }
            return entity;
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    private boolean isEmpty(InputStream body) {
        return StreamCopy.emptyStream() == body;
    }

    private String location(Entity entity) {
        EntityHeader loc = entity.headers().header(HttpHeader.LOCATION);
        String location = null;
        if (!NullOrEmpty.nullOrEmpty((Iterable)loc)) {
            location = loc.value();
        }
        return location;
    }

    private void setContentDisposition(HttpServletResponse response, EntityHeaders headers) {
        String contentDisposition = null;
        EntityHeader cd = headers.header(HttpHeader.CONTENT_DISPOSITION);
        if (!NullOrEmpty.nullOrEmpty((Iterable)cd)) {
            contentDisposition = cd.value();
        }
        if (contentDisposition != null) {
            CharSequence normalized = ContentDisposition.normalize((CharSequence)contentDisposition);
            LOG.fine("Normalized Content-Disposition from: " + contentDisposition + " to : " + normalized);
            response.setHeader(HttpHeader.CONTENT_DISPOSITION.text(), normalized.toString());
        }
    }

    private void setContentType(HttpServletResponse response, EntityHeaders headers) {
        String contentType = null;
        EntityHeader ct = headers.header(HttpHeader.CONTENT_TYPE);
        if (!NullOrEmpty.nullOrEmpty((Iterable)ct)) {
            contentType = ct.value();
        }
        if (contentType != null) {
            response.setContentType(contentType);
            Text.setCharacterEncoding((ServletResponse)response);
        }
    }

    private void storeSessionState(RequestEntity request, HttpServletResponse response, HasSessionAttributes sessionState) {
        Map<String, Object> servletSession = sessionState.session();
        if (!NullOrEmpty.nullOrEmpty(servletSession)) {
            Requests.invalidateSession(request);
            for (Map.Entry<String, Object> entry : servletSession.entrySet()) {
                String attributeName = entry.getKey();
                Object attributeValue = entry.getValue();
                Requests.sessionAttribute(request, attributeName, attributeValue);
            }
        }
    }

    private boolean unknown(String contentType) {
        return null == contentType || "content/unknown".equals(contentType);
    }
}

