/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.ecid.ECID;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.pools.SchemaIdentifier;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceLocatorException;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.dispatch.DispatchScore;
import oracle.dbtools.http.ecid.ECIDs;
import oracle.dbtools.http.errors.InternalServerException;
import oracle.dbtools.http.errors.ServletResponseException;
import oracle.dbtools.http.servlet.DispatchableServlet;
import oracle.dbtools.http.servlet.DispatchableServletBase;
import oracle.dbtools.http.servlet.DispatchableServletDependencies;
import oracle.dbtools.http.servlet.HttpRequests;
import oracle.dbtools.http.servlet.UriRequest;
import oracle.dbtools.listener.icap.InfectedFileException;
import oracle.dbtools.listener.icap.UnavailableException;
import oracle.dbtools.plugin.api.di.annotations.Optional;
import oracle.dbtools.plugin.api.di.annotations.Priority;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.logging.Log;
import oracle.dbtools.plugin.api.security.AuthorizationConstraint;
import oracle.dbtools.rt.ApexWorkspaceTenantPrincipal;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.ResourceTemplatesException;
import oracle.dbtools.rt.ResourceTemplatesScore;
import oracle.dbtools.rt.ServletResponses;
import oracle.dbtools.rt.authentication.IdentityDomainSecurityConfig;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.web.ETags;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Provides
@Priority(value=-2)
public class ResourceTemplatesServlet
extends DispatchableServletBase
implements DispatchableServlet {
    private final AuthorizationConstraint authConstraint;
    private final ECIDs ecids;
    private final Log log;
    private final SchemaIdentifier schemaId;
    private static final long serialVersionUID = 5420847081939300971L;

    @Inject
    ResourceTemplatesServlet(DispatchableServletDependencies deps, ECIDs ecids, @Named(value="apex") SchemaIdentifier schemaId, HttpRequests requests, @Optional AuthorizationConstraint authConstraint) {
        super(deps);
        this.log = deps.log();
        this.schemaId = schemaId;
        this.ecids = ecids;
        this.authConstraint = authConstraint;
    }

    public DispatchScore canDispatch(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        try {
            RequestEntity req = this.request(httpRequest);
            ResourceDispatcher.Score score = this.choose(req);
            if (ResourceDispatcher.NO_MATCH.equals(score)) {
                return DispatchScore.CANNOT_DISPATCH;
            }
            return new ResourceTemplatesScore(score);
        }
        catch (WebException e) {
            URI contextPath = UriRequest.uriRequest((HttpServletRequest)httpRequest).getContextPathURI();
            throw this.adapt(contextPath, e);
        }
        catch (Throwable t) {
            throw new InternalServerException(t, new oracle.dbtools.http.errors.Reason[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        ServletResponses response = new ServletResponses(this.getServletContext(), resp);
        try {
            this.restfulServices(request, response);
        }
        catch (WebException e) {
            URI contextPath = UriRequest.uriRequest((HttpServletRequest)request).getContextPathURI();
            throw this.adapt(contextPath, e);
        }
    }

    private ServletResponseException adapt(URI contextPath, WebException e) {
        return new ResourceTemplatesException(contextPath, e);
    }

    private ResourceDispatcher.Score addAuthConstraint(ResourceDispatcher.Score requestScore) {
        if (this.authConstraint == null) {
            return requestScore;
        }
        Pair target = (Pair)requestScore.handle();
        ResourceDispatcher.Score targetScore = (ResourceDispatcher.Score)target.first();
        IdentityDomainSecurityConfig securityConfig = new IdentityDomainSecurityConfig(targetScore.securityRealm(), this.authConstraint);
        ResourceDispatcher.Score modifiedTargetScore = new ResourceDispatcher.Score(targetScore.type(), targetScore.score(), (SecurityConfig)securityConfig, targetScore.handle(), targetScore.isCorsEnabled());
        ResourceDispatcher targetDispatcher = (ResourceDispatcher)target.second();
        Pair modifiedTarget = Pair.pair((Object)modifiedTargetScore, (Object)targetDispatcher);
        ResourceDispatcher.Score modifiedScore = new ResourceDispatcher.Score(requestScore.type(), requestScore.score(), (SecurityConfig)securityConfig, (Object)modifiedTarget, requestScore.isCorsEnabled());
        return modifiedScore;
    }

    private HttpServletRequest addEcidPrincipal(HttpServletRequest request, ECID ecid) {
        if (ecid != null) {
            return (HttpServletRequest)this.requests.modify(request).addAttribute("ECID-Principal", (Object)new ECIDPrincipal(ecid)).build();
        }
        return request;
    }

    private HttpServletRequest addTenantPrincipal(HttpServletRequest request, SchemaIdentifier schemaId) {
        ApexWorkspaceTenantPrincipal tenant = new ApexWorkspaceTenantPrincipal(schemaId);
        HttpServletRequest withTenant = (HttpServletRequest)this.requests.modify(request).addAttribute("__tenant_principal", (Object)tenant).build();
        return withTenant;
    }

    private ResourceDispatcher.Score choose(RequestEntity request) throws IOException {
        ResourceDispatcher.Score score = this.dispatchers().canDispatch(request);
        return score;
    }

    private final RequestDispatchers dispatchers() {
        return (RequestDispatchers)ServiceLocator.acquire(RequestDispatchers.class);
    }

    private RequestEntity injectJDBCPrincipal(RequestEntity req) {
        JDBCCallProvider jdbc = this.jdbcProvider();
        if (jdbc != null) {
            JDBCPrincipal principal = jdbc.principal(this.schemaId.poolIdentifer());
            req = Requests.replacePrincipal(req, (Principal)principal, JDBCPrincipal.class);
        }
        return req;
    }

    private JDBCCallProvider jdbcProvider() {
        try {
            return (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        }
        catch (ServiceLocatorException e) {
            this.log.finest((Throwable)e);
            return null;
        }
    }

    private RequestEntity request(HttpServletRequest request) throws IOException {
        ECID ecid = this.ecids.ecid(request);
        request = this.addEcidPrincipal(request, ecid);
        request = this.addTenantPrincipal(request, this.schemaId);
        RequestEntity req = Requests.request(request);
        req = Requests.replacePrincipal(req, (Principal)new ECIDPrincipal(ecid), ECIDPrincipal.class);
        req = this.injectJDBCPrincipal(req);
        return req;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restfulServices(HttpServletRequest request, ServletResponses response) throws IOException, ServletException {
        ResourceDispatcher.Score requestScore = this.score(request);
        ResourceDispatcher.Score score = this.addAuthConstraint(requestScore);
        ETags etags = new ETags();
        Entity res = null;
        RequestEntity req = null;
        try {
            req = this.request(request);
            HttpResource httpResponse = etags.checkPrecondition(score, req, this.dispatchers());
            res = httpResponse.response(req);
            response.sendResponse(req.path(), res);
        }
        catch (URIs.IllegalURIException e) {
            try {
                throw WebException.badRequest(Reason.reason("uri", e.getTranslatableMessage())).cause(e);
                catch (JDBCException e2) {
                    throw ResourceTemplatesServlet.checkForDbLimitExceeded(e2);
                }
                catch (ConnectionPoolException e3) {
                    throw WebException.serviceUnavailable().cause(e3).reasons(Reason.reason("pool", e3.getTranslatableMessage()));
                }
                catch (InfectedFileException e4) {
                    throw WebException.badRequest(Reason.reason("request.body", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "HttpEndpointBase.0", "Content is infected", new Object[0]))).cause(e4);
                }
                catch (UnavailableException e5) {
                    throw WebException.serviceUnavailable().cause(e5).reasons(Reason.reason("cause", e5.getTranslatableMessage()));
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{req, res});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{req, res});
    }

    private ResourceDispatcher.Score score(HttpServletRequest request) {
        ResourceTemplatesScore score = (ResourceTemplatesScore)((Object)request.getAttribute("oracle.dbtools.http.servlet.dispatch.score"));
        return score.score;
    }

    private static RuntimeException checkForDbLimitExceeded(JDBCException e) {
        if (JDBCException.Kind.LIMIT_EXCEEDED == e.kind()) {
            Reason reason = Reason.reason("db.limit", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "HttpEndpointBase.2", "This request exceeded a database limit", new Object[0]));
            return WebException.serviceUnavailable().cause(e).reasons(reason);
        }
        return e;
    }
}

